/*
 * Decompiled with CFR 0.152.
 */
package org.bson.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.bson.io.OutputBuffer;
import org.bson.io.UTF8Encoding;
import org.bson.util.SimplePool;

public class PoolOutputBuffer
extends OutputBuffer {
    public static final int BUF_SIZE = 16384;
    final byte[] _mine = new byte[16384];
    final char[] _chars = new char[16384];
    final List<byte[]> _fromPool = new ArrayList<byte[]>();
    final UTF8Encoding _encoding = new UTF8Encoding();
    private static final String DEFAULT_ENCODING_1 = "UTF-8";
    private static final String DEFAULT_ENCODING_2 = "UTF8";
    private final Position _cur = new Position();
    private final Position _end = new Position();
    private static SimplePool<byte[]> _extra = new SimplePool<byte[]>(640){

        @Override
        protected byte[] createNew() {
            return new byte[16384];
        }
    };

    public PoolOutputBuffer() {
        this.reset();
    }

    public void reset() {
        this._cur.reset();
        this._end.reset();
        for (int i2 = 0; i2 < this._fromPool.size(); ++i2) {
            _extra.done(this._fromPool.get(i2));
        }
        this._fromPool.clear();
    }

    public int getPosition() {
        return this._cur.pos();
    }

    public void setPosition(int position) {
        this._cur.reset(position);
    }

    public void seekEnd() {
        this._cur.reset(this._end);
    }

    public void seekStart() {
        this._cur.reset();
    }

    public int size() {
        return this._end.pos();
    }

    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) {
        while (len > 0) {
            byte[] bs = this._cur();
            int space = Math.min(bs.length - this._cur.y, len);
            System.arraycopy(b, off, bs, this._cur.y, space);
            this._cur.inc(space);
            len -= space;
            off += space;
            this._afterWrite();
        }
    }

    public void write(int b) {
        byte[] bs = this._cur();
        bs[this._cur.getAndInc()] = (byte)(b & 0xFF);
        this._afterWrite();
    }

    void _afterWrite() {
        if (this._cur.pos() < this._end.pos()) {
            if (this._cur.y == 16384) {
                this._cur.nextBuffer();
            }
            return;
        }
        this._end.reset(this._cur);
        if (this._end.y < 16384) {
            return;
        }
        this._fromPool.add(_extra.get());
        this._end.nextBuffer();
        this._cur.reset(this._end);
    }

    byte[] _cur() {
        return this._get(this._cur.x);
    }

    byte[] _get(int z) {
        if (z < 0) {
            return this._mine;
        }
        return this._fromPool.get(z);
    }

    public int pipe(OutputStream out) throws IOException {
        if (out == null) {
            throw new NullPointerException("out is null");
        }
        int total2 = 0;
        for (int i2 = -1; i2 < this._fromPool.size(); ++i2) {
            byte[] b = this._get(i2);
            int amt = this._end.len(i2);
            out.write(b, 0, amt);
            total2 += amt;
        }
        return total2;
    }

    public String asAscii() {
        if (this._fromPool.size() > 0) {
            return super.asString();
        }
        int m = this.size();
        char[] c = m < this._chars.length ? this._chars : new char[m];
        for (int i2 = 0; i2 < m; ++i2) {
            c[i2] = (char)this._mine[i2];
        }
        return new String(c, 0, m);
    }

    public String asString(String encoding2) throws UnsupportedEncodingException {
        if (this._fromPool.size() > 0) {
            return super.asString(encoding2);
        }
        if (encoding2.equals(DEFAULT_ENCODING_1) || encoding2.equals(DEFAULT_ENCODING_2)) {
            try {
                return this._encoding.decode(this._mine, 0, this.size());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new String(this._mine, 0, this.size(), encoding2);
    }

    static class Position {
        int x;
        int y;

        Position() {
            this.reset();
        }

        void reset() {
            this.x = -1;
            this.y = 0;
        }

        void reset(Position other) {
            this.x = other.x;
            this.y = other.y;
        }

        void reset(int pos2) {
            this.x = pos2 / 16384 - 1;
            this.y = pos2 % 16384;
        }

        int pos() {
            return (this.x + 1) * 16384 + this.y;
        }

        int getAndInc() {
            return this.y++;
        }

        void inc(int amt) {
            this.y += amt;
            if (this.y > 16384) {
                throw new IllegalArgumentException("something is wrong");
            }
        }

        void nextBuffer() {
            if (this.y != 16384) {
                throw new IllegalArgumentException("broken");
            }
            ++this.x;
            this.y = 0;
        }

        int len(int which) {
            if (which < this.x) {
                return 16384;
            }
            return this.y;
        }

        public String toString() {
            return this.x + "," + this.y;
        }
    }
}

