/*
 * Decompiled with CFR 0.152.
 */
package org.cyberneko.dtd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.cyberneko.dtd.SecuritySupport;

class ObjectFactory {
    private static final String DEFAULT_PROPERTIES_FILENAME = "xerces.properties";
    private static final boolean DEBUG = false;
    private static final int DEFAULT_LINE_LENGTH = 80;
    private static Properties fXercesProperties = null;
    private static long fLastModified = -1L;

    ObjectFactory() {
    }

    static Object createObject(String string2, String string3) throws ConfigurationError {
        return ObjectFactory.createObject(string2, null, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object createObject(String string2, String string3, String string4) throws ConfigurationError {
        Object object;
        String string5;
        SecuritySupport securitySupport = SecuritySupport.getInstance();
        ClassLoader classLoader = ObjectFactory.findClassLoader();
        try {
            string5 = securitySupport.getSystemProperty(string2);
            if (string5 != null) {
                return ObjectFactory.newInstance(string5, classLoader, true);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        string5 = null;
        if (string3 == null) {
            Object object2;
            object = null;
            boolean bl = false;
            try {
                object2 = securitySupport.getSystemProperty("java.home");
                string3 = (String)object2 + File.separator + "lib" + File.separator + DEFAULT_PROPERTIES_FILENAME;
                object = new File(string3);
                bl = securitySupport.getFileExists((File)object);
            }
            catch (SecurityException securityException) {
                fLastModified = -1L;
                fXercesProperties = null;
            }
            object2 = ObjectFactory.class;
            synchronized (ObjectFactory.class) {
                boolean bl2 = false;
                try {
                    if (fLastModified >= 0L) {
                        if (bl && fLastModified < (fLastModified = securitySupport.getLastModified((File)object))) {
                            bl2 = true;
                        } else if (!bl) {
                            fLastModified = -1L;
                            fXercesProperties = null;
                        }
                    } else if (bl) {
                        bl2 = true;
                        fLastModified = securitySupport.getLastModified((File)object);
                    }
                    if (bl2) {
                        fXercesProperties = new Properties();
                        FileInputStream fileInputStream = securitySupport.getFileInputStream((File)object);
                        fXercesProperties.load(fileInputStream);
                        fileInputStream.close();
                    }
                }
                catch (Exception exception2) {
                    fXercesProperties = null;
                    fLastModified = -1L;
                }
                if (fXercesProperties != null) {
                    string5 = fXercesProperties.getProperty(string2);
                }
            }
        } else {
            try {
                object = securitySupport.getFileInputStream(new File(string3));
                Properties properties = new Properties();
                properties.load((InputStream)object);
                ((FileInputStream)object).close();
                string5 = properties.getProperty(string2);
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        {
            if (string5 != null) {
                return ObjectFactory.newInstance(string5, classLoader, true);
            }
            object = ObjectFactory.findJarServiceProvider(string2);
            if (object != null) {
                return object;
            }
            if (string4 == null) {
                throw new ConfigurationError("Provider for " + string2 + " cannot be found", null);
            }
            return ObjectFactory.newInstance(string4, classLoader, true);
        }
    }

    private static void debugPrintln(String string2) {
    }

    static ClassLoader findClassLoader() throws ConfigurationError {
        ClassLoader classLoader;
        SecuritySupport securitySupport = SecuritySupport.getInstance();
        ClassLoader classLoader2 = securitySupport.getContextClassLoader();
        ClassLoader classLoader3 = classLoader = securitySupport.getSystemClassLoader();
        while (true) {
            if (classLoader2 == classLoader3) {
                ClassLoader classLoader4 = ObjectFactory.class.getClassLoader();
                classLoader3 = classLoader;
                while (true) {
                    if (classLoader4 == classLoader3) {
                        return classLoader;
                    }
                    if (classLoader3 == null) break;
                    classLoader3 = securitySupport.getParentClassLoader(classLoader3);
                }
                return classLoader4;
            }
            if (classLoader3 == null) break;
            classLoader3 = securitySupport.getParentClassLoader(classLoader3);
        }
        return classLoader2;
    }

    static Object newInstance(String string2, ClassLoader classLoader, boolean bl) throws ConfigurationError {
        try {
            Class clazz = ObjectFactory.findProviderClass(string2, classLoader, bl);
            Object t = clazz.newInstance();
            return t;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationError("Provider " + string2 + " not found", classNotFoundException);
        }
        catch (Exception exception2) {
            throw new ConfigurationError("Provider " + string2 + " could not be instantiated: " + exception2, exception2);
        }
    }

    static Class findProviderClass(String string2, ClassLoader classLoader, boolean bl) throws ClassNotFoundException, ConfigurationError {
        Class<?> clazz;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            int n = string2.lastIndexOf(".");
            String string3 = string2;
            if (n != -1) {
                string3 = string2.substring(0, n);
            }
            securityManager.checkPackageAccess(string3);
        }
        if (classLoader == null) {
            clazz = Class.forName(string2);
        } else {
            try {
                clazz = classLoader.loadClass(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (bl) {
                    ClassLoader classLoader2 = ObjectFactory.class.getClassLoader();
                    if (classLoader2 == null) {
                        clazz = Class.forName(string2);
                    }
                    if (classLoader != classLoader2) {
                        classLoader = classLoader2;
                        clazz = classLoader.loadClass(string2);
                    }
                    throw classNotFoundException;
                }
                throw classNotFoundException;
            }
        }
        return clazz;
    }

    private static Object findJarServiceProvider(String string2) throws ConfigurationError {
        Object object;
        SecuritySupport securitySupport = SecuritySupport.getInstance();
        String string3 = "META-INF/services/" + string2;
        InputStream inputStream = null;
        ClassLoader classLoader = ObjectFactory.findClassLoader();
        inputStream = securitySupport.getResourceAsStream(classLoader, string3);
        if (inputStream == null && classLoader != (object = ObjectFactory.class.getClassLoader())) {
            classLoader = object;
            inputStream = securitySupport.getResourceAsStream(classLoader, string3);
        }
        if (inputStream == null) {
            return null;
        }
        try {
            object = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"), 80);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = new BufferedReader(new InputStreamReader(inputStream), 80);
        }
        String string4 = null;
        try {
            string4 = ((BufferedReader)object).readLine();
            ((BufferedReader)object).close();
        }
        catch (IOException iOException) {
            return null;
        }
        if (string4 != null && !"".equals(string4)) {
            return ObjectFactory.newInstance(string4, classLoader, false);
        }
        return null;
    }

    static class ConfigurationError
    extends Error {
        private Exception exception;

        ConfigurationError(String string2, Exception exception2) {
            super(string2);
            this.exception = exception2;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

