/*
 * Decompiled with CFR 0.152.
 */
package org.cyberneko.html.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.xerces.util.ErrorHandlerWrapper;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.cyberneko.html.HTMLConfiguration;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class DOMFragmentParser
implements XMLDocumentHandler {
    protected static final String DOCUMENT_FRAGMENT = "http://cyberneko.org/html/features/document-fragment";
    protected static final String[] RECOGNIZED_FEATURES = new String[]{"http://cyberneko.org/html/features/document-fragment"};
    protected static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    protected static final String CURRENT_ELEMENT_NODE = "http://apache.org/xml/properties/dom/current-element-node";
    protected static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/error-handler", "http://apache.org/xml/properties/dom/current-element-node"};
    protected XMLParserConfiguration fParserConfiguration = new HTMLConfiguration();
    protected XMLDocumentSource fDocumentSource;
    protected DocumentFragment fDocumentFragment;
    protected Document fDocument;
    protected Node fCurrentNode;
    protected boolean fInCDATASection;

    public DOMFragmentParser() {
        this.fParserConfiguration.addRecognizedFeatures(RECOGNIZED_FEATURES);
        this.fParserConfiguration.addRecognizedProperties(RECOGNIZED_PROPERTIES);
        this.fParserConfiguration.setFeature(DOCUMENT_FRAGMENT, true);
        this.fParserConfiguration.setDocumentHandler(this);
    }

    public void parse(String systemId, DocumentFragment fragment) throws SAXException, IOException {
        this.parse(new InputSource(systemId), fragment);
    }

    public void parse(InputSource source2, DocumentFragment fragment) throws SAXException, IOException {
        this.fDocumentFragment = fragment;
        this.fCurrentNode = this.fDocumentFragment;
        this.fDocument = this.fDocumentFragment.getOwnerDocument();
        try {
            String pubid = source2.getPublicId();
            String sysid = source2.getSystemId();
            String encoding2 = source2.getEncoding();
            InputStream stream = source2.getByteStream();
            Reader reader = source2.getCharacterStream();
            XMLInputSource inputSource = new XMLInputSource(pubid, sysid, sysid);
            inputSource.setEncoding(encoding2);
            inputSource.setByteStream(stream);
            inputSource.setCharacterStream(reader);
            this.fParserConfiguration.parse(inputSource);
        }
        catch (XMLParseException e) {
            Exception ex = e.getException();
            if (ex != null) {
                throw new SAXParseException(e.getMessage(), null, ex);
            }
            throw new SAXParseException(e.getMessage(), null);
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.fParserConfiguration.setErrorHandler(new ErrorHandlerWrapper(errorHandler));
    }

    public ErrorHandler getErrorHandler() {
        ErrorHandler errorHandler = null;
        try {
            XMLErrorHandler xmlErrorHandler = (XMLErrorHandler)this.fParserConfiguration.getProperty(ERROR_HANDLER);
            if (xmlErrorHandler != null && xmlErrorHandler instanceof ErrorHandlerWrapper) {
                errorHandler = ((ErrorHandlerWrapper)xmlErrorHandler).getErrorHandler();
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
        return errorHandler;
    }

    public void setFeature(String featureId, boolean state2) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            this.fParserConfiguration.setFeature(featureId, state2);
        }
        catch (XMLConfigurationException e) {
            String message2 = e.getMessage();
            if (e.getType() == 0) {
                throw new SAXNotRecognizedException(message2);
            }
            throw new SAXNotSupportedException(message2);
        }
    }

    public boolean getFeature(String featureId) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            return this.fParserConfiguration.getFeature(featureId);
        }
        catch (XMLConfigurationException e) {
            String message2 = e.getMessage();
            if (e.getType() == 0) {
                throw new SAXNotRecognizedException(message2);
            }
            throw new SAXNotSupportedException(message2);
        }
    }

    public void setProperty(String propertyId, Object value2) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            this.fParserConfiguration.setProperty(propertyId, value2);
        }
        catch (XMLConfigurationException e) {
            String message2 = e.getMessage();
            if (e.getType() == 0) {
                throw new SAXNotRecognizedException(message2);
            }
            throw new SAXNotSupportedException(message2);
        }
    }

    public Object getProperty(String propertyId) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (propertyId.equals(CURRENT_ELEMENT_NODE)) {
            return this.fCurrentNode != null && this.fCurrentNode.getNodeType() == 1 ? this.fCurrentNode : null;
        }
        try {
            return this.fParserConfiguration.getProperty(propertyId);
        }
        catch (XMLConfigurationException e) {
            String message2 = e.getMessage();
            if (e.getType() == 0) {
                throw new SAXNotRecognizedException(message2);
            }
            throw new SAXNotSupportedException(message2);
        }
    }

    public void setDocumentSource(XMLDocumentSource source2) {
        this.fDocumentSource = source2;
    }

    public XMLDocumentSource getDocumentSource() {
        return this.fDocumentSource;
    }

    public void startDocument(XMLLocator locator, String encoding2, Augmentations augs) throws XNIException {
        this.startDocument(locator, encoding2, null, augs);
    }

    public void startDocument(XMLLocator locator, String encoding2, NamespaceContext nscontext, Augmentations augs) throws XNIException {
        this.fInCDATASection = false;
    }

    public void xmlDecl(String version, String encoding2, String standalone, Augmentations augs) throws XNIException {
    }

    public void doctypeDecl(String root, String pubid, String sysid, Augmentations augs) throws XNIException {
    }

    public void processingInstruction(String target, XMLString data2, Augmentations augs) throws XNIException {
        ProcessingInstruction pi = this.fDocument.createProcessingInstruction(target, data2.toString());
        this.fCurrentNode.appendChild(pi);
    }

    public void comment(XMLString text, Augmentations augs) throws XNIException {
        Comment comment2 = this.fDocument.createComment(text.toString());
        this.fCurrentNode.appendChild(comment2);
    }

    public void startPrefixMapping(String prefix, String uri, Augmentations augs) throws XNIException {
    }

    public void endPrefixMapping(String prefix, Augmentations augs) throws XNIException {
    }

    public void startElement(QName element, XMLAttributes attrs, Augmentations augs) throws XNIException {
        Element elementNode = this.fDocument.createElement(element.rawname);
        int count2 = attrs != null ? attrs.getLength() : 0;
        for (int i2 = 0; i2 < count2; ++i2) {
            String aname = attrs.getQName(i2);
            String avalue = attrs.getValue(i2);
            elementNode.setAttribute(aname, avalue);
        }
        this.fCurrentNode.appendChild(elementNode);
        this.fCurrentNode = elementNode;
    }

    public void emptyElement(QName element, XMLAttributes attrs, Augmentations augs) throws XNIException {
        this.startElement(element, attrs, augs);
        this.endElement(element, augs);
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
        if (this.fInCDATASection) {
            Node node = this.fCurrentNode.getLastChild();
            if (node != null && node.getNodeType() == 4) {
                CDATASection cdata = (CDATASection)node;
                cdata.appendData(text.toString());
            } else {
                CDATASection cdata = this.fDocument.createCDATASection(text.toString());
                this.fCurrentNode.appendChild(cdata);
            }
        } else {
            Node node = this.fCurrentNode.getLastChild();
            if (node != null && node.getNodeType() == 3) {
                Text textNode = (Text)node;
                textNode.appendData(text.toString());
            } else {
                Text textNode = this.fDocument.createTextNode(text.toString());
                this.fCurrentNode.appendChild(textNode);
            }
        }
    }

    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        this.characters(text, augs);
    }

    public void startGeneralEntity(String name2, XMLResourceIdentifier id2, String encoding2, Augmentations augs) throws XNIException {
        EntityReference entityRef = this.fDocument.createEntityReference(name2);
        this.fCurrentNode.appendChild(entityRef);
        this.fCurrentNode = entityRef;
    }

    public void textDecl(String version, String encoding2, Augmentations augs) throws XNIException {
    }

    public void endGeneralEntity(String name2, Augmentations augs) throws XNIException {
        this.fCurrentNode = this.fCurrentNode.getParentNode();
    }

    public void startCDATA(Augmentations augs) throws XNIException {
        this.fInCDATASection = true;
    }

    public void endCDATA(Augmentations augs) throws XNIException {
        this.fInCDATASection = false;
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        this.fCurrentNode = this.fCurrentNode.getParentNode();
    }

    public void endDocument(Augmentations augs) throws XNIException {
    }
}

