/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.rest.RestStatus;

public class ElasticSearchException
extends RuntimeException {
    public ElasticSearchException(String msg) {
        super(msg);
    }

    public ElasticSearchException(String msg, Throwable cause2) {
        super(msg, cause2);
    }

    public RestStatus status() {
        Throwable cause2 = this.unwrapCause();
        if (cause2 == this) {
            return RestStatus.INTERNAL_SERVER_ERROR;
        }
        if (cause2 instanceof ElasticSearchException) {
            return ((ElasticSearchException)cause2).status();
        }
        if (cause2 instanceof IllegalArgumentException) {
            return RestStatus.BAD_REQUEST;
        }
        return RestStatus.INTERNAL_SERVER_ERROR;
    }

    public Throwable unwrapCause() {
        return ExceptionsHelper.unwrapCause(this);
    }

    public String getDetailedMessage() {
        if (this.getCause() != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.toString()).append("; ");
            if (this.getCause() instanceof ElasticSearchException) {
                sb.append(((ElasticSearchException)this.getCause()).getDetailedMessage());
            } else {
                sb.append(this.getCause());
            }
            return sb.toString();
        }
        return super.toString();
    }

    public Throwable getRootCause() {
        Throwable rootCause = this;
        for (Throwable cause2 = this.getCause(); cause2 != null && cause2 != rootCause; cause2 = cause2.getCause()) {
            rootCause = cause2;
        }
        return rootCause;
    }

    public Throwable getMostSpecificCause() {
        Throwable rootCause = this.getRootCause();
        return rootCause != null ? rootCause : this;
    }

    public boolean contains(Class exType) {
        if (exType == null) {
            return false;
        }
        if (exType.isInstance(this)) {
            return true;
        }
        Throwable cause2 = this.getCause();
        if (cause2 == this) {
            return false;
        }
        if (cause2 instanceof ElasticSearchException) {
            return ((ElasticSearchException)cause2).contains(exType);
        }
        while (cause2 != null) {
            if (exType.isInstance(cause2)) {
                return true;
            }
            if (cause2.getCause() == cause2) break;
            cause2 = cause2.getCause();
        }
        return false;
    }
}

