/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchWrapperException;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.rest.RestStatus;

public final class ExceptionsHelper {
    private static final ESLogger logger = Loggers.getLogger(ExceptionsHelper.class);

    public static RestStatus status(Throwable t) {
        if (t instanceof ElasticSearchException) {
            return ((ElasticSearchException)t).status();
        }
        return RestStatus.INTERNAL_SERVER_ERROR;
    }

    public static Throwable unwrapCause(Throwable t) {
        int counter = 0;
        Throwable result2 = t;
        while (result2 instanceof ElasticSearchWrapperException) {
            if (result2.getCause() == null) {
                return result2;
            }
            if (result2.getCause() == result2) {
                return result2;
            }
            if (counter++ > 10) {
                logger.warn("Exception cause unwrapping ran for 10 levels...", t, new Object[0]);
                return result2;
            }
            result2 = result2.getCause();
        }
        return result2;
    }

    public static String detailedMessage(Throwable t) {
        return ExceptionsHelper.detailedMessage(t, false, 0);
    }

    public static String detailedMessage(Throwable t, boolean newLines, int initialCounter) {
        if (t == null) {
            return "Unknown";
        }
        int counter = initialCounter + 1;
        if (t.getCause() != null) {
            StringBuilder sb = new StringBuilder();
            while (t != null) {
                sb.append(t.getClass().getSimpleName());
                if (t.getMessage() != null) {
                    sb.append("[");
                    sb.append(t.getMessage());
                    sb.append("]");
                }
                if (!newLines) {
                    sb.append("; ");
                }
                if ((t = t.getCause()) != null) {
                    if (newLines) {
                        sb.append("\n");
                        for (int i2 = 0; i2 < counter; ++i2) {
                            sb.append("\t");
                        }
                    } else {
                        sb.append("nested: ");
                    }
                }
                ++counter;
            }
            return sb.toString();
        }
        return t.getClass().getSimpleName() + "[" + t.getMessage() + "]";
    }
}

