/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import org.elasticsearch.ElasticSearchIllegalArgumentException;

public enum WriteConsistencyLevel {
    DEFAULT(0),
    ONE(1),
    QUORUM(2),
    ALL(3);

    private final byte id;

    private WriteConsistencyLevel(byte id2) {
        this.id = id2;
    }

    public byte id() {
        return this.id;
    }

    public static WriteConsistencyLevel fromId(byte value2) {
        if (value2 == 0) {
            return DEFAULT;
        }
        if (value2 == 1) {
            return ONE;
        }
        if (value2 == 2) {
            return QUORUM;
        }
        if (value2 == 3) {
            return ALL;
        }
        throw new ElasticSearchIllegalArgumentException("No write consistency match [" + value2 + "]");
    }

    public static WriteConsistencyLevel fromString(String value2) {
        if (value2.equals("default")) {
            return DEFAULT;
        }
        if (value2.equals("one")) {
            return ONE;
        }
        if (value2.equals("quorum")) {
            return QUORUM;
        }
        if (value2.equals("all")) {
            return ALL;
        }
        throw new ElasticSearchIllegalArgumentException("No write consistency match [" + value2 + "]");
    }
}

