/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.stats;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.support.nodes.NodeOperationResponse;
import org.elasticsearch.action.support.nodes.NodesOperationResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class NodesStatsResponse
extends NodesOperationResponse<NodeStats>
implements ToXContent {
    NodesStatsResponse() {
    }

    public NodesStatsResponse(ClusterName clusterName, NodeStats[] nodes) {
        super(clusterName, (NodeOperationResponse[])nodes);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.nodes = new NodeStats[in.readVInt()];
        for (int i2 = 0; i2 < ((NodeStats[])this.nodes).length; ++i2) {
            ((NodeStats[])this.nodes)[i2] = NodeStats.readNodeStats(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(((NodeStats[])this.nodes).length);
        for (NodeStats node : (NodeStats[])this.nodes) {
            node.writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params2) throws IOException {
        builder.field("cluster_name", this.clusterName().value());
        builder.startObject("nodes");
        for (NodeStats nodeStats : this) {
            builder.startObject(nodeStats.node().id(), XContentBuilder.FieldCaseConversion.NONE);
            builder.field("timestamp", nodeStats.timestamp());
            builder.field("name", nodeStats.node().name(), XContentBuilder.FieldCaseConversion.NONE);
            builder.field("transport_address", nodeStats.node().address().toString());
            if (nodeStats.hostname() != null) {
                builder.field("hostname", nodeStats.hostname(), XContentBuilder.FieldCaseConversion.NONE);
            }
            if (!nodeStats.node().attributes().isEmpty()) {
                builder.startObject("attributes");
                for (Map.Entry attr2 : nodeStats.node().attributes().entrySet()) {
                    builder.field((String)attr2.getKey(), (String)attr2.getValue());
                }
                builder.endObject();
            }
            if (nodeStats.indices() != null) {
                nodeStats.indices().toXContent(builder, params2);
            }
            if (nodeStats.os() != null) {
                nodeStats.os().toXContent(builder, params2);
            }
            if (nodeStats.process() != null) {
                nodeStats.process().toXContent(builder, params2);
            }
            if (nodeStats.jvm() != null) {
                nodeStats.jvm().toXContent(builder, params2);
            }
            if (nodeStats.threadPool() != null) {
                nodeStats.threadPool().toXContent(builder, params2);
            }
            if (nodeStats.network() != null) {
                nodeStats.network().toXContent(builder, params2);
            }
            if (nodeStats.fs() != null) {
                nodeStats.fs().toXContent(builder, params2);
            }
            if (nodeStats.transport() != null) {
                nodeStats.transport().toXContent(builder, params2);
            }
            if (nodeStats.http() != null) {
                nodeStats.http().toXContent(builder, params2);
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }
}

