/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.state;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ClusterStateResponse
extends ActionResponse {
    private ClusterName clusterName;
    private ClusterState clusterState;

    public ClusterStateResponse() {
    }

    ClusterStateResponse(ClusterName clusterName, ClusterState clusterState) {
        this.clusterName = clusterName;
        this.clusterState = clusterState;
    }

    public ClusterState state() {
        return this.clusterState;
    }

    public ClusterState getState() {
        return this.state();
    }

    public ClusterName clusterName() {
        return this.clusterName;
    }

    public ClusterName getClusterName() {
        return this.clusterName();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.clusterName = ClusterName.readClusterName(in);
        this.clusterState = ClusterState.Builder.readFrom(in, null);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.clusterName.writeTo(out);
        ClusterState.Builder.writeTo(this.clusterState, out);
    }
}

