/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.cache.clear;

import java.io.IOException;
import org.elasticsearch.action.support.broadcast.BroadcastOperationRequest;
import org.elasticsearch.action.support.broadcast.BroadcastOperationThreading;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ClearIndicesCacheRequest
extends BroadcastOperationRequest<ClearIndicesCacheRequest> {
    private boolean filterCache = false;
    private boolean fieldDataCache = false;
    private boolean idCache = false;
    private String[] fields = null;
    private String[] filterKeys = null;

    ClearIndicesCacheRequest() {
    }

    public ClearIndicesCacheRequest(String ... indices2) {
        super(indices2);
        this.operationThreading(BroadcastOperationThreading.THREAD_PER_SHARD);
    }

    public boolean filterCache() {
        return this.filterCache;
    }

    public ClearIndicesCacheRequest filterCache(boolean filterCache) {
        this.filterCache = filterCache;
        return this;
    }

    public boolean fieldDataCache() {
        return this.fieldDataCache;
    }

    public ClearIndicesCacheRequest fieldDataCache(boolean fieldDataCache) {
        this.fieldDataCache = fieldDataCache;
        return this;
    }

    public ClearIndicesCacheRequest fields(String ... fields2) {
        this.fields = fields2;
        return this;
    }

    public String[] fields() {
        return this.fields;
    }

    public ClearIndicesCacheRequest filterKeys(String ... filterKeys) {
        this.filterKeys = filterKeys;
        return this;
    }

    public String[] filterKeys() {
        return this.filterKeys;
    }

    public boolean idCache() {
        return this.idCache;
    }

    public ClearIndicesCacheRequest idCache(boolean idCache) {
        this.idCache = idCache;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.filterCache = in.readBoolean();
        this.fieldDataCache = in.readBoolean();
        this.idCache = in.readBoolean();
        this.fields = in.readStringArray();
        this.filterKeys = in.readStringArray();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.filterCache);
        out.writeBoolean(this.fieldDataCache);
        out.writeBoolean(this.idCache);
        out.writeStringArrayNullable(this.fields);
        out.writeStringArrayNullable(this.filterKeys);
    }
}

