/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.create;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticSearchGenerationException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;

public class CreateIndexRequest
extends MasterNodeOperationRequest<CreateIndexRequest> {
    private String cause = "";
    private String index;
    private Settings settings = ImmutableSettings.Builder.EMPTY_SETTINGS;
    private Map<String, String> mappings = Maps.newHashMap();
    private Map<String, IndexMetaData.Custom> customs = Maps.newHashMap();
    private TimeValue timeout = new TimeValue(10L, TimeUnit.SECONDS);

    CreateIndexRequest() {
    }

    public CreateIndexRequest(String index2) {
        this(index2, ImmutableSettings.Builder.EMPTY_SETTINGS);
    }

    public CreateIndexRequest(String index2, Settings settings) {
        this.index = index2;
        this.settings = settings;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.index == null) {
            validationException = ValidateActions.addValidationError("index is missing", validationException);
        }
        return validationException;
    }

    String index() {
        return this.index;
    }

    public CreateIndexRequest index(String index2) {
        this.index = index2;
        return this;
    }

    Settings settings() {
        return this.settings;
    }

    String cause() {
        return this.cause;
    }

    public CreateIndexRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public CreateIndexRequest settings(Settings.Builder settings) {
        this.settings = settings.build();
        return this;
    }

    public CreateIndexRequest settings(String source2) {
        this.settings = ImmutableSettings.settingsBuilder().loadFromSource(source2).build();
        return this;
    }

    public CreateIndexRequest settings(XContentBuilder builder) {
        try {
            this.settings(builder.string());
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate json settings from builder", e);
        }
        return this;
    }

    public CreateIndexRequest settings(Map source2) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(source2);
            this.settings(builder.string());
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + source2 + "]", e);
        }
        return this;
    }

    public CreateIndexRequest mapping(String type2, String source2) {
        this.mappings.put(type2, source2);
        return this;
    }

    public CreateIndexRequest cause(String cause2) {
        this.cause = cause2;
        return this;
    }

    public CreateIndexRequest mapping(String type2, XContentBuilder source2) {
        try {
            this.mappings.put(type2, source2.string());
        }
        catch (IOException e) {
            throw new ElasticSearchIllegalArgumentException("Failed to build json for mapping request", e);
        }
        return this;
    }

    public CreateIndexRequest mapping(String type2, Map source2) {
        if (source2.size() != 1 || !source2.containsKey(type2)) {
            source2 = MapBuilder.newMapBuilder().put(type2, source2).map();
        }
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(source2);
            return this.mapping(type2, builder.string());
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + source2 + "]", e);
        }
    }

    public CreateIndexRequest source(String source2) {
        return this.source(source2.getBytes(Charsets.UTF_8));
    }

    public CreateIndexRequest source(XContentBuilder source2) {
        return this.source(source2.bytes());
    }

    public CreateIndexRequest source(byte[] source2) {
        return this.source(source2, 0, source2.length);
    }

    public CreateIndexRequest source(byte[] source2, int offset2, int length2) {
        return this.source(new BytesArray(source2, offset2, length2));
    }

    public CreateIndexRequest source(BytesReference source2) {
        XContentType xContentType = XContentFactory.xContentType(source2);
        if (xContentType != null) {
            try {
                this.source(XContentFactory.xContent(xContentType).createParser(source2).mapAndClose());
            }
            catch (IOException e) {
                throw new ElasticSearchParseException("failed to parse source for create index", e);
            }
        } else {
            this.settings(new String(source2.toBytes(), Charsets.UTF_8));
        }
        return this;
    }

    public CreateIndexRequest source(Map<String, Object> source2) {
        boolean found = false;
        for (Map.Entry<String, Object> entry : source2.entrySet()) {
            String name2 = entry.getKey();
            if (name2.equals("settings")) {
                found = true;
                this.settings((Map)entry.getValue());
                continue;
            }
            if (name2.equals("mappings")) {
                found = true;
                Map mappings = (Map)entry.getValue();
                for (Map.Entry entry1 : mappings.entrySet()) {
                    this.mapping((String)entry1.getKey(), (Map)entry1.getValue());
                }
                continue;
            }
            IndexMetaData.Custom.Factory factory = IndexMetaData.lookupFactory(name2);
            if (factory == null) continue;
            found = true;
            try {
                this.customs.put(name2, (IndexMetaData.Custom)factory.fromMap((Map)entry.getValue()));
            }
            catch (IOException e) {
                throw new ElasticSearchParseException("failed to parse custom metadata for [" + name2 + "]");
            }
        }
        if (!found) {
            this.settings(source2);
        }
        return this;
    }

    Map<String, String> mappings() {
        return this.mappings;
    }

    public CreateIndexRequest custom(IndexMetaData.Custom custom) {
        this.customs.put(custom.type(), custom);
        return this;
    }

    Map<String, IndexMetaData.Custom> customs() {
        return this.customs;
    }

    TimeValue timeout() {
        return this.timeout;
    }

    public CreateIndexRequest timeout(TimeValue timeout2) {
        this.timeout = timeout2;
        return this;
    }

    public CreateIndexRequest timeout(String timeout2) {
        return this.timeout(TimeValue.parseTimeValue(timeout2, null));
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.cause = in.readString();
        this.index = in.readString();
        this.settings = ImmutableSettings.readSettingsFromStream(in);
        this.timeout = TimeValue.readTimeValue(in);
        int size2 = in.readVInt();
        for (int i2 = 0; i2 < size2; ++i2) {
            this.mappings.put(in.readString(), in.readString());
        }
        int customSize = in.readVInt();
        for (int i3 = 0; i3 < customSize; ++i3) {
            String type2 = in.readString();
            Object customIndexMetaData = IndexMetaData.lookupFactorySafe(type2).readFrom(in);
            this.customs.put(type2, (IndexMetaData.Custom)customIndexMetaData);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.cause);
        out.writeString(this.index);
        ImmutableSettings.writeSettingsToStream(this.settings, out);
        this.timeout.writeTo(out);
        out.writeVInt(this.mappings.size());
        for (Map.Entry<String, String> entry : this.mappings.entrySet()) {
            out.writeString(entry.getKey());
            out.writeString(entry.getValue());
        }
        out.writeVInt(this.customs.size());
        for (Map.Entry<String, Object> entry : this.customs.entrySet()) {
            out.writeString(entry.getKey());
            IndexMetaData.lookupFactorySafe(entry.getKey()).writeTo((IndexMetaData.Custom)entry.getValue(), out);
        }
    }
}

