/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.delete;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public class DeleteIndexRequest
extends MasterNodeOperationRequest<DeleteIndexRequest> {
    private String[] indices;
    private TimeValue timeout = TimeValue.timeValueSeconds(10L);

    DeleteIndexRequest() {
    }

    public DeleteIndexRequest(String index2) {
        this.indices = new String[]{index2};
    }

    public DeleteIndexRequest(String ... indices2) {
        this.indices = indices2;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.indices == null) {
            validationException = ValidateActions.addValidationError("index / indices is missing", validationException);
        }
        return validationException;
    }

    public DeleteIndexRequest indices(String ... indices2) {
        this.indices = indices2;
        return this;
    }

    String[] indices() {
        return this.indices;
    }

    TimeValue timeout() {
        return this.timeout;
    }

    public DeleteIndexRequest timeout(TimeValue timeout2) {
        this.timeout = timeout2;
        return this;
    }

    public DeleteIndexRequest timeout(String timeout2) {
        return this.timeout(TimeValue.parseTimeValue(timeout2, null));
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indices = new String[in.readVInt()];
        for (int i2 = 0; i2 < this.indices.length; ++i2) {
            this.indices[i2] = in.readString();
        }
        this.timeout = TimeValue.readTimeValue(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.indices == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.indices.length);
            for (String index2 : this.indices) {
                out.writeString(index2);
            }
        }
        this.timeout.writeTo(out);
    }
}

