/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.open;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public class OpenIndexRequest
extends MasterNodeOperationRequest<OpenIndexRequest> {
    private String index;
    private TimeValue timeout = TimeValue.timeValueSeconds(10L);

    OpenIndexRequest() {
    }

    public OpenIndexRequest(String index2) {
        this.index = index2;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.index == null) {
            validationException = ValidateActions.addValidationError("index is missing", validationException);
        }
        return validationException;
    }

    String index() {
        return this.index;
    }

    public OpenIndexRequest index(String index2) {
        this.index = index2;
        return this;
    }

    TimeValue timeout() {
        return this.timeout;
    }

    public OpenIndexRequest timeout(TimeValue timeout2) {
        this.timeout = timeout2;
        return this;
    }

    public OpenIndexRequest timeout(String timeout2) {
        return this.timeout(TimeValue.parseTimeValue(timeout2, null));
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.index = in.readString();
        this.timeout = TimeValue.readTimeValue(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.index);
        this.timeout.writeTo(out);
    }
}

