/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.stats;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.indices.stats.CommonStats;
import org.elasticsearch.action.admin.indices.stats.IndexShardStats;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;

public class IndexStats
implements Iterable<IndexShardStats> {
    private final String index;
    private final ShardStats[] shards;
    private Map<Integer, IndexShardStats> indexShards;
    private CommonStats total = null;
    private CommonStats primary = null;

    public IndexStats(String index2, ShardStats[] shards) {
        this.index = index2;
        this.shards = shards;
    }

    public String index() {
        return this.index;
    }

    public ShardStats[] shards() {
        return this.shards;
    }

    public Map<Integer, IndexShardStats> indexShards() {
        if (this.indexShards != null) {
            return this.indexShards;
        }
        HashMap tmpIndexShards = Maps.newHashMap();
        for (ShardStats shard : this.shards) {
            ArrayList<ShardStats> lst = (ArrayList<ShardStats>)tmpIndexShards.get(shard.shardRouting().id());
            if (lst == null) {
                lst = Lists.newArrayList();
                tmpIndexShards.put(shard.shardRouting().id(), lst);
            }
            lst.add(shard);
        }
        this.indexShards = Maps.newHashMap();
        for (Map.Entry entry : tmpIndexShards.entrySet()) {
            this.indexShards.put((Integer)entry.getKey(), new IndexShardStats(((ShardStats)((List)entry.getValue()).get(0)).shardRouting().shardId(), ((List)entry.getValue()).toArray(new ShardStats[((List)entry.getValue()).size()])));
        }
        return this.indexShards;
    }

    @Override
    public Iterator<IndexShardStats> iterator() {
        return this.indexShards().values().iterator();
    }

    public CommonStats getTotal() {
        return this.total();
    }

    public CommonStats total() {
        if (this.total != null) {
            return this.total;
        }
        CommonStats stats = new CommonStats();
        for (ShardStats shard : this.shards) {
            stats.add(shard.stats());
        }
        this.total = stats;
        return stats;
    }

    public CommonStats getPrimaries() {
        return this.primaries();
    }

    public CommonStats primaries() {
        if (this.primary != null) {
            return this.primary;
        }
        CommonStats stats = new CommonStats();
        for (ShardStats shard : this.shards) {
            if (!shard.shardRouting().primary()) continue;
            stats.add(shard.stats());
        }
        this.primary = stats;
        return stats;
    }
}

