/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.stats;

import java.io.IOException;
import org.elasticsearch.action.support.broadcast.BroadcastOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class IndicesStatsRequest
extends BroadcastOperationRequest<IndicesStatsRequest> {
    private boolean docs = true;
    private boolean store = true;
    private boolean indexing = true;
    private boolean get = true;
    private boolean search = true;
    private boolean merge = false;
    private boolean refresh = false;
    private boolean flush = false;
    private boolean warmer = false;
    private String[] types = null;
    private String[] groups = null;

    public IndicesStatsRequest all() {
        this.docs = true;
        this.store = true;
        this.get = true;
        this.indexing = true;
        this.search = true;
        this.merge = true;
        this.refresh = true;
        this.flush = true;
        this.warmer = true;
        this.types = null;
        this.groups = null;
        return this;
    }

    public IndicesStatsRequest clear() {
        this.docs = false;
        this.store = false;
        this.get = false;
        this.indexing = false;
        this.search = false;
        this.merge = false;
        this.refresh = false;
        this.flush = false;
        this.warmer = false;
        this.types = null;
        this.groups = null;
        return this;
    }

    public IndicesStatsRequest types(String ... types) {
        this.types = types;
        return this;
    }

    public String[] types() {
        return this.types;
    }

    public IndicesStatsRequest groups(String ... groups2) {
        this.groups = groups2;
        return this;
    }

    public String[] groups() {
        return this.groups;
    }

    public IndicesStatsRequest docs(boolean docs) {
        this.docs = docs;
        return this;
    }

    public boolean docs() {
        return this.docs;
    }

    public IndicesStatsRequest store(boolean store) {
        this.store = store;
        return this;
    }

    public boolean store() {
        return this.store;
    }

    public IndicesStatsRequest indexing(boolean indexing) {
        this.indexing = indexing;
        return this;
    }

    public boolean indexing() {
        return this.indexing;
    }

    public IndicesStatsRequest get(boolean get2) {
        this.get = get2;
        return this;
    }

    public boolean get() {
        return this.get;
    }

    public IndicesStatsRequest search(boolean search) {
        this.search = search;
        return this;
    }

    public boolean search() {
        return this.search;
    }

    public IndicesStatsRequest merge(boolean merge2) {
        this.merge = merge2;
        return this;
    }

    public boolean merge() {
        return this.merge;
    }

    public IndicesStatsRequest refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public IndicesStatsRequest flush(boolean flush2) {
        this.flush = flush2;
        return this;
    }

    public boolean flush() {
        return this.flush;
    }

    public IndicesStatsRequest warmer(boolean warmer) {
        this.warmer = warmer;
        return this;
    }

    public boolean warmer() {
        return this.warmer;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.docs);
        out.writeBoolean(this.store);
        out.writeBoolean(this.indexing);
        out.writeBoolean(this.get);
        out.writeBoolean(this.search);
        out.writeBoolean(this.merge);
        out.writeBoolean(this.flush);
        out.writeBoolean(this.refresh);
        out.writeBoolean(this.warmer);
        if (this.types == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.types.length);
            for (String type2 : this.types) {
                out.writeUTF(type2);
            }
        }
        if (this.groups == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.groups.length);
            for (String group2 : this.groups) {
                out.writeUTF(group2);
            }
        }
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int i2;
        super.readFrom(in);
        this.docs = in.readBoolean();
        this.store = in.readBoolean();
        this.indexing = in.readBoolean();
        this.get = in.readBoolean();
        this.search = in.readBoolean();
        this.merge = in.readBoolean();
        this.flush = in.readBoolean();
        this.refresh = in.readBoolean();
        this.warmer = in.readBoolean();
        int size2 = in.readVInt();
        if (size2 > 0) {
            this.types = new String[size2];
            for (i2 = 0; i2 < size2; ++i2) {
                this.types[i2] = in.readUTF();
            }
        }
        if ((size2 = in.readVInt()) > 0) {
            this.groups = new String[size2];
            for (i2 = 0; i2 < size2; ++i2) {
                this.groups[i2] = in.readUTF();
            }
        }
    }
}

