/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.status;

import java.util.Iterator;
import org.elasticsearch.action.admin.indices.status.DocsStatus;
import org.elasticsearch.action.admin.indices.status.ShardStatus;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.flush.FlushStats;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.refresh.RefreshStats;
import org.elasticsearch.index.shard.ShardId;

public class IndexShardStatus
implements Iterable<ShardStatus> {
    private final ShardId shardId;
    private final ShardStatus[] shards;
    private transient DocsStatus docs;

    IndexShardStatus(ShardId shardId, ShardStatus[] shards) {
        this.shardId = shardId;
        this.shards = shards;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public ShardId getShardId() {
        return this.shardId();
    }

    public ShardStatus[] shards() {
        return this.shards;
    }

    public ShardStatus[] getShards() {
        return this.shards();
    }

    public ShardStatus getAt(int position) {
        return this.shards[position];
    }

    public ByteSizeValue primaryStoreSize() {
        long bytes2 = -1L;
        for (ShardStatus shard : this.shards()) {
            if (!shard.shardRouting().primary() || shard.storeSize() == null) continue;
            if (bytes2 == -1L) {
                bytes2 = 0L;
            }
            bytes2 += shard.storeSize().bytes();
        }
        if (bytes2 == -1L) {
            return null;
        }
        return new ByteSizeValue(bytes2);
    }

    public ByteSizeValue getPrimaryStoreSize() {
        return this.primaryStoreSize();
    }

    public ByteSizeValue storeSize() {
        long bytes2 = -1L;
        for (ShardStatus shard : this.shards()) {
            if (shard.storeSize() == null) continue;
            if (bytes2 == -1L) {
                bytes2 = 0L;
            }
            bytes2 += shard.storeSize().bytes();
        }
        if (bytes2 == -1L) {
            return null;
        }
        return new ByteSizeValue(bytes2);
    }

    public ByteSizeValue getStoreSize() {
        return this.storeSize();
    }

    public long translogOperations() {
        long translogOperations = -1L;
        for (ShardStatus shard : this.shards()) {
            if (shard.translogOperations() == -1L) continue;
            if (translogOperations == -1L) {
                translogOperations = 0L;
            }
            translogOperations += shard.translogOperations();
        }
        return translogOperations;
    }

    public long getTranslogOperations() {
        return this.translogOperations();
    }

    public DocsStatus docs() {
        if (this.docs != null) {
            return this.docs;
        }
        DocsStatus docs = null;
        for (ShardStatus shard : this.shards()) {
            if (!shard.shardRouting().primary() || shard.docs() == null) continue;
            if (docs == null) {
                docs = new DocsStatus();
            }
            docs.numDocs += shard.docs().numDocs();
            docs.maxDoc += shard.docs().maxDoc();
            docs.deletedDocs += shard.docs().deletedDocs();
        }
        this.docs = docs;
        return this.docs;
    }

    public DocsStatus getDocs() {
        return this.docs();
    }

    public MergeStats mergeStats() {
        MergeStats mergeStats = new MergeStats();
        for (ShardStatus shard : this.shards) {
            mergeStats.add(shard.mergeStats());
        }
        return mergeStats;
    }

    public MergeStats getMergeStats() {
        return this.mergeStats();
    }

    public RefreshStats refreshStats() {
        RefreshStats refreshStats = new RefreshStats();
        for (ShardStatus shard : this.shards) {
            refreshStats.add(shard.refreshStats());
        }
        return refreshStats;
    }

    public RefreshStats getRefreshStats() {
        return this.refreshStats();
    }

    public FlushStats flushStats() {
        FlushStats flushStats = new FlushStats();
        for (ShardStatus shard : this.shards) {
            flushStats.add(shard.flushStats);
        }
        return flushStats;
    }

    public FlushStats getFlushStats() {
        return this.flushStats();
    }

    @Override
    public Iterator<ShardStatus> iterator() {
        return Iterators.forArray(this.shards);
    }
}

