/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.warmer.put;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.admin.indices.warmer.put.PutWarmerRequest;
import org.elasticsearch.action.admin.indices.warmer.put.PutWarmerResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.search.warmer.IndexWarmersMetaData;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportPutWarmerAction
extends TransportMasterNodeOperationAction<PutWarmerRequest, PutWarmerResponse> {
    private final TransportSearchAction searchAction;

    @Inject
    public TransportPutWarmerAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, TransportSearchAction searchAction) {
        super(settings, transportService, clusterService, threadPool);
        this.searchAction = searchAction;
    }

    @Override
    protected String executor() {
        return "management";
    }

    @Override
    protected String transportAction() {
        return "indices/warmer/put";
    }

    @Override
    protected PutWarmerRequest newRequest() {
        return new PutWarmerRequest();
    }

    @Override
    protected PutWarmerResponse newResponse() {
        return new PutWarmerResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(PutWarmerRequest request, ClusterState state2) {
        String[] concreteIndices = this.clusterService.state().metaData().concreteIndices(request.searchRequest().indices());
        return state2.blocks().indicesBlockedException(ClusterBlockLevel.METADATA, concreteIndices);
    }

    @Override
    protected PutWarmerResponse masterOperation(final PutWarmerRequest request, ClusterState state2) throws ElasticSearchException {
        SearchResponse searchResponse = (SearchResponse)this.searchAction.execute(request.searchRequest()).actionGet();
        if (searchResponse.failedShards() > 0) {
            throw new ElasticSearchException("search failed with failed shards: " + Arrays.toString(searchResponse.shardFailures()));
        }
        AtomicReference<InterruptedException> failureRef = new AtomicReference<InterruptedException>();
        final CountDownLatch latch = new CountDownLatch(1);
        this.clusterService.submitStateUpdateTask("put_warmer [" + request.name() + "]", new ProcessedClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                MetaData metaData = currentState.metaData();
                String[] concreteIndices = metaData.concreteIndices(request.searchRequest().indices());
                BytesReference source2 = null;
                if (request.searchRequest().source() != null && request.searchRequest().source().length() > 0) {
                    source2 = request.searchRequest().source();
                } else if (request.searchRequest().extraSource() != null && request.searchRequest().extraSource().length() > 0) {
                    source2 = request.searchRequest().extraSource();
                }
                MetaData.Builder mdBuilder = MetaData.builder().metaData(currentState.metaData());
                for (String index2 : concreteIndices) {
                    IndexMetaData indexMetaData = metaData.index(index2);
                    if (indexMetaData == null) {
                        throw new IndexMissingException(new Index(index2));
                    }
                    IndexWarmersMetaData warmers = (IndexWarmersMetaData)indexMetaData.custom("warmers");
                    if (warmers == null) {
                        TransportPutWarmerAction.this.logger.info("[{}] putting warmer [{}]", index2, request.name());
                        warmers = new IndexWarmersMetaData(new IndexWarmersMetaData.Entry(request.name(), request.searchRequest().types(), source2));
                    } else {
                        boolean found = false;
                        ArrayList<IndexWarmersMetaData.Entry> entries2 = new ArrayList<IndexWarmersMetaData.Entry>(warmers.entries().size() + 1);
                        for (IndexWarmersMetaData.Entry entry : warmers.entries()) {
                            if (entry.name().equals(request.name())) {
                                found = true;
                                entries2.add(new IndexWarmersMetaData.Entry(request.name(), request.searchRequest().types(), source2));
                                continue;
                            }
                            entries2.add(entry);
                        }
                        if (!found) {
                            TransportPutWarmerAction.this.logger.info("[{}] put warmer [{}]", index2, request.name());
                            entries2.add(new IndexWarmersMetaData.Entry(request.name(), request.searchRequest().types(), source2));
                        } else {
                            TransportPutWarmerAction.this.logger.info("[{}] update warmer [{}]", index2, request.name());
                        }
                        warmers = new IndexWarmersMetaData(entries2.toArray(new IndexWarmersMetaData.Entry[entries2.size()]));
                    }
                    IndexMetaData.Builder indexBuilder = IndexMetaData.newIndexMetaDataBuilder(indexMetaData).putCustom("warmers", warmers);
                    mdBuilder.put(indexBuilder);
                }
                return ClusterState.builder().state(currentState).metaData(mdBuilder).build();
            }

            @Override
            public void clusterStateProcessed(ClusterState clusterState) {
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            failureRef.set(e);
        }
        if (failureRef.get() != null) {
            if (failureRef.get() instanceof ElasticSearchException) {
                throw (ElasticSearchException)failureRef.get();
            }
            throw new ElasticSearchException(((Throwable)failureRef.get()).getMessage(), (Throwable)failureRef.get());
        }
        return new PutWarmerResponse(true);
    }
}

