/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.deletebyquery;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.deletebyquery.IndexDeleteByQueryResponse;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class DeleteByQueryResponse
extends ActionResponse
implements Iterable<IndexDeleteByQueryResponse> {
    private Map<String, IndexDeleteByQueryResponse> indices = Maps.newHashMap();

    DeleteByQueryResponse() {
    }

    @Override
    public Iterator<IndexDeleteByQueryResponse> iterator() {
        return this.indices.values().iterator();
    }

    public Map<String, IndexDeleteByQueryResponse> indices() {
        return this.indices;
    }

    public Map<String, IndexDeleteByQueryResponse> getIndices() {
        return this.indices;
    }

    public IndexDeleteByQueryResponse index(String index2) {
        return this.indices.get(index2);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size2 = in.readVInt();
        for (int i2 = 0; i2 < size2; ++i2) {
            IndexDeleteByQueryResponse response = new IndexDeleteByQueryResponse();
            response.readFrom(in);
            this.indices.put(response.index(), response);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.indices.size());
        for (IndexDeleteByQueryResponse indexResponse : this.indices.values()) {
            indexResponse.writeTo(out);
        }
    }
}

