/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.support.IgnoreIndices;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;

public class MultiSearchRequest
extends ActionRequest<MultiSearchRequest> {
    private List<SearchRequest> requests = Lists.newArrayList();
    private IgnoreIndices ignoreIndices = IgnoreIndices.DEFAULT;

    public MultiSearchRequest add(SearchRequestBuilder request) {
        this.requests.add(request.request());
        return this;
    }

    public MultiSearchRequest add(SearchRequest request) {
        this.requests.add(request);
        return this;
    }

    public MultiSearchRequest add(byte[] data2, int from, int length2, boolean contentUnsafe, @Nullable String[] indices2, @Nullable String[] types, @Nullable String searchType) throws Exception {
        return this.add(new BytesArray(data2, from, length2), contentUnsafe, indices2, types, searchType, IgnoreIndices.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiSearchRequest add(BytesReference data2, boolean contentUnsafe, @Nullable String[] indices2, @Nullable String[] types, @Nullable String searchType, IgnoreIndices ignoreIndices) throws Exception {
        int nextMarker;
        XContent xContent = XContentFactory.xContent(data2);
        int from = 0;
        int length2 = data2.length();
        byte marker = xContent.streamSeparator();
        while ((nextMarker = this.findNextMarker(marker, from, data2, length2)) != -1) {
            if (nextMarker == 0) {
                from = nextMarker + 1;
                continue;
            }
            SearchRequest searchRequest = new SearchRequest(indices2);
            if (ignoreIndices != null) {
                searchRequest.ignoreIndices(ignoreIndices);
            }
            if (types != null && types.length > 0) {
                searchRequest.types(types);
            }
            searchRequest.searchType(searchType);
            if (nextMarker - from > 0) {
                XContentParser parser = xContent.createParser(data2.slice(from, nextMarker - from));
                try {
                    XContentParser.Token token = parser.nextToken();
                    if (token != null) {
                        assert (token == XContentParser.Token.START_OBJECT);
                        String currentFieldName = null;
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token.isValue()) {
                                if ("index".equals(currentFieldName) || "indices".equals(currentFieldName)) {
                                    searchRequest.indices(Strings.splitStringByCommaToArray(parser.text()));
                                    continue;
                                }
                                if ("type".equals(currentFieldName) || "types".equals(currentFieldName)) {
                                    searchRequest.types(Strings.splitStringByCommaToArray(parser.text()));
                                    continue;
                                }
                                if ("search_type".equals(currentFieldName) || "searchType".equals(currentFieldName)) {
                                    searchRequest.searchType(parser.text());
                                    continue;
                                }
                                if ("preference".equals(currentFieldName)) {
                                    searchRequest.preference(parser.text());
                                    continue;
                                }
                                if ("routing".equals(currentFieldName)) {
                                    searchRequest.routing(parser.text());
                                    continue;
                                }
                                if ("query_hint".equals(currentFieldName) || "queryHint".equals(currentFieldName)) {
                                    searchRequest.queryHint(parser.text());
                                    continue;
                                }
                                if (!"ignore_indices".equals(currentFieldName) && !"ignoreIndices".equals(currentFieldName)) continue;
                                searchRequest.ignoreIndices(IgnoreIndices.fromString(parser.text()));
                                continue;
                            }
                            if (token != XContentParser.Token.START_ARRAY) continue;
                            if ("index".equals(currentFieldName) || "indices".equals(currentFieldName)) {
                                searchRequest.indices(this.parseArray(parser));
                                continue;
                            }
                            if ("type".equals(currentFieldName) || "types".equals(currentFieldName)) {
                                searchRequest.types(this.parseArray(parser));
                                continue;
                            }
                            throw new ElasticSearchParseException(currentFieldName + " doesn't support arrays");
                        }
                    }
                }
                finally {
                    parser.close();
                }
            }
            if ((nextMarker = this.findNextMarker(marker, from = nextMarker + 1, data2, length2)) == -1) break;
            searchRequest.source(data2.slice(from, nextMarker - from), contentUnsafe);
            from = nextMarker + 1;
            this.add(searchRequest);
        }
        return this;
    }

    private String[] parseArray(XContentParser parser) throws IOException {
        ArrayList<String> list2 = new ArrayList<String>();
        assert (parser.currentToken() == XContentParser.Token.START_ARRAY);
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            list2.add(parser.text());
        }
        return list2.toArray(new String[list2.size()]);
    }

    private int findNextMarker(byte marker, int from, BytesReference data2, int length2) {
        for (int i2 = from; i2 < length2; ++i2) {
            if (data2.get(i2) != marker) continue;
            return i2;
        }
        return -1;
    }

    public List<SearchRequest> requests() {
        return this.requests;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.requests.isEmpty()) {
            validationException = ValidateActions.addValidationError("no requests added", validationException);
        }
        for (int i2 = 0; i2 < this.requests.size(); ++i2) {
            ActionRequestValidationException ex = this.requests.get(i2).validate();
            if (ex == null) continue;
            if (validationException == null) {
                validationException = new ActionRequestValidationException();
            }
            validationException.addValidationErrors(ex.validationErrors());
        }
        return validationException;
    }

    public IgnoreIndices ignoreIndices() {
        return this.ignoreIndices;
    }

    public MultiSearchRequest ignoreIndices(IgnoreIndices ignoreIndices) {
        this.ignoreIndices = ignoreIndices;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size2 = in.readVInt();
        for (int i2 = 0; i2 < size2; ++i2) {
            SearchRequest request = new SearchRequest();
            request.readFrom(in);
            this.requests.add(request);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.requests.size());
        for (SearchRequest request : this.requests) {
            request.writeTo(out);
        }
    }
}

