/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.support.AdapterActionFuture;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class AbstractListenableActionFuture<T, L>
extends AdapterActionFuture<T, L>
implements ListenableActionFuture<T> {
    final boolean listenerThreaded;
    final ThreadPool threadPool;
    volatile Object listeners;
    boolean executedListeners = false;

    protected AbstractListenableActionFuture(boolean listenerThreaded, ThreadPool threadPool) {
        this.listenerThreaded = listenerThreaded;
        this.threadPool = threadPool;
    }

    public boolean listenerThreaded() {
        return false;
    }

    public ThreadPool threadPool() {
        return this.threadPool;
    }

    @Override
    public void addListener(ActionListener<T> listener) {
        this.internalAddListener(listener);
    }

    @Override
    public void addListener(Runnable listener) {
        this.internalAddListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalAddListener(Object listener) {
        boolean executeImmediate = false;
        AbstractListenableActionFuture abstractListenableActionFuture = this;
        synchronized (abstractListenableActionFuture) {
            if (this.executedListeners) {
                executeImmediate = true;
            } else {
                ArrayList listeners = this.listeners;
                if (listeners == null) {
                    listeners = listener;
                } else if (listeners instanceof List) {
                    ((List)this.listeners).add(listener);
                } else {
                    ArrayList orig = listeners;
                    listeners = Lists.newArrayListWithCapacity(2);
                    ((List)listeners).add(orig);
                    ((List)listeners).add(listener);
                }
                this.listeners = listeners;
            }
        }
        if (executeImmediate) {
            this.executeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void done() {
        super.done();
        AbstractListenableActionFuture abstractListenableActionFuture = this;
        synchronized (abstractListenableActionFuture) {
            this.executedListeners = true;
        }
        Object listeners = this.listeners;
        if (listeners != null) {
            if (listeners instanceof List) {
                List list2 = (List)listeners;
                for (Object listener : list2) {
                    this.executeListener(listener);
                }
            } else {
                this.executeListener(listeners);
            }
        }
    }

    private void executeListener(final Object listener) {
        if (this.listenerThreaded) {
            if (listener instanceof Runnable) {
                this.threadPool.generic().execute((Runnable)listener);
            } else {
                this.threadPool.generic().execute(new Runnable(){

                    @Override
                    public void run() {
                        ActionListener lst = (ActionListener)listener;
                        try {
                            lst.onResponse(AbstractListenableActionFuture.this.actionGet());
                        }
                        catch (ElasticSearchException e) {
                            lst.onFailure(e);
                        }
                    }
                });
            }
        } else if (listener instanceof Runnable) {
            ((Runnable)listener).run();
        } else {
            ActionListener lst = (ActionListener)listener;
            try {
                lst.onResponse(this.actionGet());
            }
            catch (ElasticSearchException e) {
                lst.onFailure(e);
            }
        }
    }
}

