/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import org.elasticsearch.ElasticSearchIllegalArgumentException;

public enum ReplicationType {
    SYNC(0),
    ASYNC(1),
    DEFAULT(2);

    private byte id;

    private ReplicationType(byte id2) {
        this.id = id2;
    }

    public byte id() {
        return this.id;
    }

    public static ReplicationType fromId(byte id2) {
        if (id2 == 0) {
            return ASYNC;
        }
        if (id2 == 1) {
            return SYNC;
        }
        if (id2 == 2) {
            return DEFAULT;
        }
        throw new ElasticSearchIllegalArgumentException("No type match for [" + id2 + "]");
    }

    public static ReplicationType fromString(String type2) {
        if ("async".equals(type2)) {
            return ASYNC;
        }
        if ("sync".equals(type2)) {
            return SYNC;
        }
        if ("default".equals(type2)) {
            return DEFAULT;
        }
        throw new ElasticSearchIllegalArgumentException("No replication type match for [" + type2 + "], should be either `async`, or `sync`");
    }
}

