/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.CreationException;
import org.elasticsearch.common.inject.spi.Message;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.jna.Natives;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.logging.log4j.LogConfigurator;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.elasticsearch.node.internal.InternalSettingsPerparer;

public class Bootstrap {
    private Node node;
    private static volatile Thread keepAliveThread;
    private static volatile CountDownLatch keepAliveLatch;
    private static Bootstrap bootstrap;

    private void setup(boolean addShutdownHook, Tuple<Settings, Environment> tuple) throws Exception {
        if (tuple.v1().getAsBoolean("bootstrap.mlockall", false).booleanValue()) {
            Natives.tryMlockall();
        }
        tuple = Bootstrap.setupJmx(tuple);
        NodeBuilder nodeBuilder = NodeBuilder.nodeBuilder().settings(tuple.v1()).loadConfigSettings(false);
        this.node = nodeBuilder.build();
        if (addShutdownHook) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    Bootstrap.this.node.close();
                }
            });
        }
    }

    private static Tuple<Settings, Environment> setupJmx(Tuple<Settings, Environment> tuple) {
        return tuple;
    }

    private static void setupLogging(Tuple<Settings, Environment> tuple) {
        try {
            tuple.v1().getClassLoader().loadClass("org.apache.log4j.Logger");
            LogConfigurator.configure(tuple.v1());
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoClassDefFoundError e) {
        }
        catch (Exception e) {
            System.err.println("Failed to configure logging...");
            e.printStackTrace();
        }
    }

    private static Tuple<Settings, Environment> initialSettings() {
        return InternalSettingsPerparer.prepareSettings(ImmutableSettings.Builder.EMPTY_SETTINGS, true);
    }

    public void init(String[] args2) throws Exception {
        Tuple<Settings, Environment> tuple = Bootstrap.initialSettings();
        Bootstrap.setupLogging(tuple);
        this.setup(true, tuple);
    }

    public void start() {
        this.node.start();
    }

    public void stop() {
        this.node.stop();
    }

    public void destroy() {
        this.node.close();
    }

    public static void close(String[] args2) {
        bootstrap.destroy();
        keepAliveLatch.countDown();
    }

    public static void main(String[] args2) {
        ESLogger logger;
        boolean foreground;
        System.setProperty("es.logger.prefix", "");
        bootstrap = new Bootstrap();
        String pidFile = System.getProperty("es.pidfile", System.getProperty("es-pidfile"));
        if (pidFile != null) {
            try {
                File fPidFile = new File(pidFile);
                if (fPidFile.getParentFile() != null) {
                    FileSystemUtils.mkdirs(fPidFile.getParentFile());
                }
                RandomAccessFile rafPidFile = new RandomAccessFile(fPidFile, "rw");
                rafPidFile.writeBytes(Long.toString(JvmInfo.jvmInfo().pid()));
                rafPidFile.close();
                fPidFile.deleteOnExit();
            }
            catch (Exception e) {
                String errorMessage = Bootstrap.buildErrorMessage("pid", e);
                System.err.println(errorMessage);
                System.err.flush();
                System.exit(3);
            }
        }
        boolean bl = foreground = System.getProperty("es.foreground", System.getProperty("es-foreground")) != null;
        if (System.getProperty("wrapper.service", "XXX").equalsIgnoreCase("true")) {
            foreground = false;
        }
        Tuple<Settings, Environment> tuple = null;
        try {
            tuple = Bootstrap.initialSettings();
            Bootstrap.setupLogging(tuple);
        }
        catch (Exception e) {
            String errorMessage = Bootstrap.buildErrorMessage("Setup", e);
            System.err.println(errorMessage);
            System.err.flush();
            System.exit(3);
        }
        if (System.getProperty("es.max-open-files", "false").equals("true")) {
            logger = Loggers.getLogger(Bootstrap.class);
            logger.info("max_open_files [{}]", FileSystemUtils.maxOpenFiles(new File(tuple.v2().workFile(), "open_files")));
        }
        if (JvmInfo.jvmInfo().vmName().toLowerCase().contains("client")) {
            logger = Loggers.getLogger(Bootstrap.class);
            logger.warn("jvm uses the client vm, make sure to run `java` with the server vm for best performance by adding `-server` to the command line", new Object[0]);
        }
        String stage = "Initialization";
        try {
            if (!foreground) {
                Loggers.disableConsoleLogging();
                System.out.close();
            }
            bootstrap.setup(true, tuple);
            stage = "Startup";
            bootstrap.start();
            if (!foreground) {
                System.err.close();
            }
            keepAliveLatch = new CountDownLatch(1);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    keepAliveLatch.countDown();
                }
            });
            keepAliveThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        keepAliveLatch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }, "elasticsearch[keepAlive/" + Version.CURRENT + "]");
            keepAliveThread.setDaemon(false);
            keepAliveThread.start();
        }
        catch (Throwable e) {
            ESLogger logger2 = Loggers.getLogger(Bootstrap.class);
            if (Bootstrap.bootstrap.node != null) {
                logger2 = Loggers.getLogger(Bootstrap.class, Bootstrap.bootstrap.node.settings().get("name"));
            }
            String errorMessage = Bootstrap.buildErrorMessage(stage, e);
            if (foreground) {
                logger2.error(errorMessage, new Object[0]);
            } else {
                System.err.println(errorMessage);
                System.err.flush();
            }
            Loggers.disableConsoleLogging();
            if (logger2.isDebugEnabled()) {
                logger2.debug("Exception", e, new Object[0]);
            }
            System.exit(3);
        }
    }

    private static String buildErrorMessage(String stage, Throwable e) {
        StringBuilder errorMessage = new StringBuilder("{").append(Version.CURRENT).append("}: ");
        errorMessage.append(stage).append(" Failed ...\n");
        if (e instanceof CreationException) {
            CreationException createException = (CreationException)e;
            HashSet<String> seenMessages = Sets.newHashSet();
            int counter = 1;
            for (Message message2 : createException.getErrorMessages()) {
                String detailedMessage = message2.getCause() == null ? message2.getMessage() : ExceptionsHelper.detailedMessage(message2.getCause(), true, 0);
                if (detailedMessage == null) {
                    detailedMessage = message2.getMessage();
                }
                if (seenMessages.contains(detailedMessage)) continue;
                seenMessages.add(detailedMessage);
                errorMessage.append("").append(counter++).append(") ").append(detailedMessage);
            }
        } else {
            errorMessage.append("- ").append(ExceptionsHelper.detailedMessage(e, true, 0));
        }
        return errorMessage.toString();
    }
}

