/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Lists;

public class ClusterChangedEvent {
    private final String source;
    private final ClusterState previousState;
    private final ClusterState state;
    private final DiscoveryNodes.Delta nodesDelta;

    public ClusterChangedEvent(String source2, ClusterState state2, ClusterState previousState) {
        this.source = source2;
        this.state = state2;
        this.previousState = previousState;
        this.nodesDelta = state2.nodes().delta(previousState.nodes());
    }

    public String source() {
        return this.source;
    }

    public ClusterState state() {
        return this.state;
    }

    public ClusterState previousState() {
        return this.previousState;
    }

    public boolean routingTableChanged() {
        return this.state.routingTable() != this.previousState.routingTable();
    }

    public boolean indexRoutingTableChanged(String index2) {
        if (!this.state.routingTable().hasIndex(index2) && !this.previousState.routingTable().hasIndex(index2)) {
            return false;
        }
        if (this.state.routingTable().hasIndex(index2) && this.previousState.routingTable().hasIndex(index2)) {
            return this.state.routingTable().index(index2) != this.previousState.routingTable().index(index2);
        }
        return true;
    }

    public List<String> indicesCreated() {
        if (this.previousState == null) {
            return Lists.newArrayList(this.state.metaData().indices().keySet());
        }
        if (!this.metaDataChanged()) {
            return ImmutableList.of();
        }
        ArrayList<String> created = null;
        for (String index2 : this.state.metaData().indices().keySet()) {
            if (this.previousState.metaData().hasIndex(index2)) continue;
            if (created == null) {
                created = Lists.newArrayList();
            }
            created.add(index2);
        }
        return created == null ? ImmutableList.of() : created;
    }

    public List<String> indicesDeleted() {
        if (this.previousState == null) {
            return ImmutableList.of();
        }
        if (!this.metaDataChanged()) {
            return ImmutableList.of();
        }
        ArrayList<String> deleted = null;
        for (String index2 : this.previousState.metaData().indices().keySet()) {
            if (this.state.metaData().hasIndex(index2)) continue;
            if (deleted == null) {
                deleted = Lists.newArrayList();
            }
            deleted.add(index2);
        }
        return deleted == null ? ImmutableList.of() : deleted;
    }

    public boolean metaDataChanged() {
        return this.state.metaData() != this.previousState.metaData();
    }

    public boolean indexMetaDataChanged(IndexMetaData current2) {
        MetaData previousMetaData = this.previousState.metaData();
        if (previousMetaData == null) {
            return true;
        }
        IndexMetaData previousIndexMetaData = previousMetaData.index(current2.index());
        return previousIndexMetaData != current2;
    }

    public boolean blocksChanged() {
        return this.state.blocks() != this.previousState.blocks();
    }

    public boolean localNodeMaster() {
        return this.state.nodes().localNodeMaster();
    }

    public DiscoveryNodes.Delta nodesDelta() {
        return this.nodesDelta;
    }

    public boolean nodesRemoved() {
        return this.nodesDelta.removed();
    }

    public boolean nodesAdded() {
        return this.nodesDelta.added();
    }

    public boolean nodesChanged() {
        return this.nodesRemoved() || this.nodesAdded();
    }
}

