/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.action.index;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class NodeAliasesUpdatedAction
extends AbstractComponent {
    private final ThreadPool threadPool;
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();

    @Inject
    public NodeAliasesUpdatedAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService) {
        super(settings);
        this.threadPool = threadPool;
        this.transportService = transportService;
        this.clusterService = clusterService;
        transportService.registerHandler("cluster/nodeAliasesUpdated", new NodeAliasesUpdatedTransportHandler());
    }

    public void add(final Listener listener, TimeValue timeout2) {
        this.listeners.add(listener);
        this.threadPool.schedule(timeout2, "generic", new Runnable(){

            @Override
            public void run() {
                boolean removed = NodeAliasesUpdatedAction.this.listeners.remove(listener);
                if (removed) {
                    listener.onTimeout();
                }
            }
        });
    }

    public void remove(Listener listener) {
        this.listeners.remove(listener);
    }

    public void nodeAliasesUpdated(final NodeAliasesUpdatedResponse response) throws ElasticSearchException {
        DiscoveryNodes nodes = this.clusterService.state().nodes();
        if (nodes.localNodeMaster()) {
            this.threadPool.generic().execute(new Runnable(){

                @Override
                public void run() {
                    NodeAliasesUpdatedAction.this.innerNodeAliasesUpdated(response);
                }
            });
        } else {
            this.transportService.sendRequest(this.clusterService.state().nodes().masterNode(), "cluster/nodeAliasesUpdated", response, EmptyTransportResponseHandler.INSTANCE_SAME);
        }
    }

    private void innerNodeAliasesUpdated(NodeAliasesUpdatedResponse response) {
        for (Listener listener : this.listeners) {
            listener.onAliasesUpdated(response);
        }
    }

    public static class NodeAliasesUpdatedResponse
    extends TransportRequest {
        private String nodeId;
        private long version;

        NodeAliasesUpdatedResponse() {
        }

        public NodeAliasesUpdatedResponse(String nodeId, long version) {
            this.nodeId = nodeId;
            this.version = version;
        }

        public String nodeId() {
            return this.nodeId;
        }

        public long version() {
            return this.version;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.nodeId);
            out.writeLong(this.version);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.nodeId = in.readString();
            this.version = in.readLong();
        }
    }

    private class NodeAliasesUpdatedTransportHandler
    extends BaseTransportRequestHandler<NodeAliasesUpdatedResponse> {
        static final String ACTION = "cluster/nodeAliasesUpdated";

        private NodeAliasesUpdatedTransportHandler() {
        }

        @Override
        public NodeAliasesUpdatedResponse newInstance() {
            return new NodeAliasesUpdatedResponse();
        }

        @Override
        public void messageReceived(NodeAliasesUpdatedResponse response, TransportChannel channel) throws Exception {
            NodeAliasesUpdatedAction.this.innerNodeAliasesUpdated(response);
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }

        @Override
        public String executor() {
            return "same";
        }
    }

    public static interface Listener {
        public void onAliasesUpdated(NodeAliasesUpdatedResponse var1);

        public void onTimeout();
    }
}

