/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.action.index;

import java.io.IOException;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.MetaDataMappingService;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class NodeMappingRefreshAction
extends AbstractComponent {
    private final ThreadPool threadPool;
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final MetaDataMappingService metaDataMappingService;

    @Inject
    public NodeMappingRefreshAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, MetaDataMappingService metaDataMappingService) {
        super(settings);
        this.threadPool = threadPool;
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.metaDataMappingService = metaDataMappingService;
        transportService.registerHandler("cluster/nodeMappingRefresh", new NodeMappingRefreshTransportHandler());
    }

    public void nodeMappingRefresh(final NodeMappingRefreshRequest request) throws ElasticSearchException {
        DiscoveryNodes nodes = this.clusterService.state().nodes();
        if (nodes.localNodeMaster()) {
            this.threadPool.generic().execute(new Runnable(){

                @Override
                public void run() {
                    NodeMappingRefreshAction.this.innerMappingRefresh(request);
                }
            });
        } else {
            this.transportService.sendRequest(this.clusterService.state().nodes().masterNode(), "cluster/nodeMappingRefresh", request, EmptyTransportResponseHandler.INSTANCE_SAME);
        }
    }

    private void innerMappingRefresh(NodeMappingRefreshRequest request) {
        this.metaDataMappingService.refreshMapping(request.index(), request.types());
    }

    public static class NodeMappingRefreshRequest
    extends TransportRequest {
        private String index;
        private String[] types;
        private String nodeId;

        NodeMappingRefreshRequest() {
        }

        public NodeMappingRefreshRequest(String index2, String[] types, String nodeId) {
            this.index = index2;
            this.types = types;
            this.nodeId = nodeId;
        }

        public String index() {
            return this.index;
        }

        public String[] types() {
            return this.types;
        }

        public String nodeId() {
            return this.nodeId;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.index);
            out.writeStringArray(this.types);
            out.writeString(this.nodeId);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.index = in.readString();
            this.types = in.readStringArray();
            this.nodeId = in.readString();
        }
    }

    private class NodeMappingRefreshTransportHandler
    extends BaseTransportRequestHandler<NodeMappingRefreshRequest> {
        static final String ACTION = "cluster/nodeMappingRefresh";

        private NodeMappingRefreshTransportHandler() {
        }

        @Override
        public NodeMappingRefreshRequest newInstance() {
            return new NodeMappingRefreshRequest();
        }

        @Override
        public void messageReceived(NodeMappingRefreshRequest request, TransportChannel channel) throws Exception {
            NodeMappingRefreshAction.this.innerMappingRefresh(request);
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }

        @Override
        public String executor() {
            return "same";
        }
    }
}

