/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.block;

import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.rest.RestStatus;

public class ClusterBlockException
extends ElasticSearchException {
    private final ImmutableSet<ClusterBlock> blocks;

    public ClusterBlockException(ImmutableSet<ClusterBlock> blocks2) {
        super(ClusterBlockException.buildMessage(blocks2));
        this.blocks = blocks2;
    }

    public boolean retryable() {
        for (ClusterBlock block : this.blocks) {
            if (block.retryable()) continue;
            return false;
        }
        return true;
    }

    public ImmutableSet<ClusterBlock> blocks() {
        return this.blocks;
    }

    private static String buildMessage(ImmutableSet<ClusterBlock> blocks2) {
        StringBuilder sb = new StringBuilder("blocked by: ");
        for (ClusterBlock block : blocks2) {
            sb.append("[").append((Object)block.status()).append("/").append(block.id()).append("/").append(block.description()).append("];");
        }
        return sb.toString();
    }

    @Override
    public RestStatus status() {
        RestStatus status2 = null;
        for (ClusterBlock block : this.blocks) {
            if (status2 == null) {
                status2 = block.status();
                continue;
            }
            if (status2.getStatus() >= block.status().getStatus()) continue;
            status2 = block.status();
        }
        return status2;
    }
}

