/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.index.shard.ShardId;

public class AllocationExplanation
implements Streamable {
    public static final AllocationExplanation EMPTY = new AllocationExplanation();
    private final Map<ShardId, List<NodeExplanation>> explanations = Maps.newHashMap();

    public AllocationExplanation add(ShardId shardId, NodeExplanation nodeExplanation) {
        List<NodeExplanation> list2 = this.explanations.get(shardId);
        if (list2 == null) {
            list2 = Lists.newArrayList();
            this.explanations.put(shardId, list2);
        }
        list2.add(nodeExplanation);
        return this;
    }

    public Map<ShardId, List<NodeExplanation>> explanations() {
        return this.explanations;
    }

    public static AllocationExplanation readAllocationExplanation(StreamInput in) throws IOException {
        AllocationExplanation e = new AllocationExplanation();
        e.readFrom(in);
        return e;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int size2 = in.readVInt();
        for (int i2 = 0; i2 < size2; ++i2) {
            ShardId shardId = ShardId.readShardId(in);
            int size22 = in.readVInt();
            ArrayList<NodeExplanation> ne = Lists.newArrayListWithCapacity(size22);
            for (int j = 0; j < size22; ++j) {
                DiscoveryNode node = null;
                if (in.readBoolean()) {
                    node = DiscoveryNode.readNode(in);
                }
                ne.add(new NodeExplanation(node, in.readUTF()));
            }
            this.explanations.put(shardId, ne);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.explanations.size());
        for (Map.Entry<ShardId, List<NodeExplanation>> entry : this.explanations.entrySet()) {
            entry.getKey().writeTo(out);
            out.writeVInt(entry.getValue().size());
            for (NodeExplanation nodeExplanation : entry.getValue()) {
                if (nodeExplanation.node() == null) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    nodeExplanation.node().writeTo(out);
                }
                out.writeUTF(nodeExplanation.description());
            }
        }
    }

    public static class NodeExplanation {
        private final DiscoveryNode node;
        private final String description;

        public NodeExplanation(DiscoveryNode node, String description) {
            this.node = node;
            this.description = description;
        }

        public DiscoveryNode node() {
            return this.node;
        }

        public String description() {
            return this.description;
        }
    }
}

