/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.allocation.FailedRerouteAllocation;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.StartedRerouteAllocation;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.trove.map.hash.TObjectIntHashMap;

public class EvenShardsCountAllocator
extends AbstractComponent
implements ShardsAllocator {
    @Inject
    public EvenShardsCountAllocator(Settings settings) {
        super(settings);
    }

    @Override
    public void applyStartedShards(StartedRerouteAllocation allocation) {
    }

    @Override
    public void applyFailedShards(FailedRerouteAllocation allocation) {
    }

    @Override
    public boolean allocateUnassigned(RoutingAllocation allocation) {
        boolean changed = false;
        RoutingNodes routingNodes = allocation.routingNodes();
        RoutingNode[] nodes = this.sortedNodesLeastToHigh(allocation);
        Iterator<MutableShardRouting> unassignedIterator = routingNodes.unassigned().iterator();
        int lastNode = 0;
        block0: while (unassignedIterator.hasNext()) {
            MutableShardRouting shard = unassignedIterator.next();
            for (int i2 = 0; i2 < nodes.length; ++i2) {
                int numberOfShardsToAllocate;
                Decision decision;
                RoutingNode node = nodes[lastNode];
                if (++lastNode == nodes.length) {
                    lastNode = 0;
                }
                if ((decision = allocation.deciders().canAllocate(shard, node, allocation)).type() != Decision.Type.YES || (numberOfShardsToAllocate = routingNodes.requiredAverageNumberOfShardsPerNode() - node.shards().size()) <= 0) continue;
                changed = true;
                node.add(shard);
                unassignedIterator.remove();
                continue block0;
            }
        }
        Iterator<MutableShardRouting> it = routingNodes.unassigned().iterator();
        block2: while (it.hasNext()) {
            MutableShardRouting shard = it.next();
            for (RoutingNode routingNode : this.sortedNodesLeastToHigh(allocation)) {
                Decision decision = allocation.deciders().canAllocate(shard, routingNode, allocation);
                if (decision.type() != Decision.Type.YES) continue;
                changed = true;
                routingNode.add(shard);
                it.remove();
                continue block2;
            }
        }
        return changed;
    }

    @Override
    public boolean rebalance(RoutingAllocation allocation) {
        boolean relocationPerformed;
        boolean changed = false;
        RoutingNode[] sortedNodesLeastToHigh = this.sortedNodesLeastToHigh(allocation);
        if (sortedNodesLeastToHigh.length == 0) {
            return false;
        }
        int lowIndex = 0;
        int highIndex = sortedNodesLeastToHigh.length - 1;
        do {
            relocationPerformed = false;
            while (lowIndex != highIndex) {
                RoutingNode lowRoutingNode = sortedNodesLeastToHigh[lowIndex];
                RoutingNode highRoutingNode = sortedNodesLeastToHigh[highIndex];
                int averageNumOfShards = allocation.routingNodes().requiredAverageNumberOfShardsPerNode();
                if (highRoutingNode.numberOfOwningShards() <= averageNumOfShards) {
                    --highIndex;
                    continue;
                }
                if (lowRoutingNode.shards().size() >= averageNumOfShards) {
                    ++lowIndex;
                    continue;
                }
                boolean relocated = false;
                List<MutableShardRouting> startedShards = highRoutingNode.shardsWithState(ShardRoutingState.STARTED);
                for (MutableShardRouting startedShard : startedShards) {
                    Decision allocateDecision;
                    Decision rebalanceDecision = allocation.deciders().canRebalance(startedShard, allocation);
                    if (rebalanceDecision.type() == Decision.Type.NO || (allocateDecision = allocation.deciders().canAllocate(startedShard, lowRoutingNode, allocation)).type() != Decision.Type.YES) continue;
                    changed = true;
                    lowRoutingNode.add(new MutableShardRouting(startedShard.index(), startedShard.id(), lowRoutingNode.nodeId(), startedShard.currentNodeId(), startedShard.primary(), ShardRoutingState.INITIALIZING, startedShard.version() + 1L));
                    startedShard.relocate(lowRoutingNode.nodeId());
                    relocated = true;
                    relocationPerformed = true;
                    break;
                }
                if (relocated) continue;
                --highIndex;
            }
        } while (relocationPerformed);
        return changed;
    }

    @Override
    public boolean move(MutableShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (!shardRouting.started()) {
            return false;
        }
        boolean changed = false;
        RoutingNode[] sortedNodesLeastToHigh = this.sortedNodesLeastToHigh(allocation);
        if (sortedNodesLeastToHigh.length == 0) {
            return false;
        }
        for (RoutingNode nodeToCheck : sortedNodesLeastToHigh) {
            Decision decision;
            if (nodeToCheck.nodeId().equals(node.nodeId()) || (decision = allocation.deciders().canAllocate(shardRouting, nodeToCheck, allocation)).type() != Decision.Type.YES) continue;
            nodeToCheck.add(new MutableShardRouting(shardRouting.index(), shardRouting.id(), nodeToCheck.nodeId(), shardRouting.currentNodeId(), shardRouting.primary(), ShardRoutingState.INITIALIZING, shardRouting.version() + 1L));
            shardRouting.relocate(nodeToCheck.nodeId());
            changed = true;
            break;
        }
        return changed;
    }

    private RoutingNode[] sortedNodesLeastToHigh(RoutingAllocation allocation) {
        final TObjectIntHashMap<String> nodeCounts = new TObjectIntHashMap<String>();
        for (RoutingNode node : allocation.routingNodes()) {
            for (int i2 = 0; i2 < node.shards().size(); ++i2) {
                ShardRouting shardRouting = node.shards().get(i2);
                String nodeId = shardRouting.relocating() ? shardRouting.relocatingNodeId() : shardRouting.currentNodeId();
                nodeCounts.adjustOrPutValue(nodeId, 1, 1);
            }
        }
        RoutingNode[] nodes = allocation.routingNodes().nodesToShards().values().toArray(new RoutingNode[allocation.routingNodes().nodesToShards().values().size()]);
        Arrays.sort(nodes, new Comparator<RoutingNode>(){

            @Override
            public int compare(RoutingNode o1, RoutingNode o2) {
                return nodeCounts.get(o1.nodeId()) - nodeCounts.get(o2.nodeId());
            }
        });
        return nodes;
    }
}

