/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.util.List;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class RebalanceOnlyWhenActiveAllocationDecider
extends AllocationDecider {
    @Inject
    public RebalanceOnlyWhenActiveAllocationDecider(Settings settings) {
        super(settings);
    }

    @Override
    public Decision canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        List<MutableShardRouting> shards = allocation.routingNodes().shardsRoutingFor(shardRouting);
        for (int i2 = 0; i2 < shards.size(); ++i2) {
            if (shards.get(i2).active()) continue;
            return Decision.NO;
        }
        return Decision.YES;
    }
}

