/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.util.Arrays;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.common.util.concurrent.ThreadLocals;

public class Unicode {
    private static ThreadLocal<ThreadLocals.CleanableValue<UnicodeUtil.UTF8Result>> cachedUtf8Result = new ThreadLocal<ThreadLocals.CleanableValue<UnicodeUtil.UTF8Result>>(){

        @Override
        protected ThreadLocals.CleanableValue<UnicodeUtil.UTF8Result> initialValue() {
            return new ThreadLocals.CleanableValue<UnicodeUtil.UTF8Result>(new UnicodeUtil.UTF8Result());
        }
    };
    private static ThreadLocal<ThreadLocals.CleanableValue<UTF16Result>> cachedUtf16Result = new ThreadLocal<ThreadLocals.CleanableValue<UTF16Result>>(){

        @Override
        protected ThreadLocals.CleanableValue<UTF16Result> initialValue() {
            return new ThreadLocals.CleanableValue<UTF16Result>(new UTF16Result());
        }
    };
    private static final long UNI_MAX_BMP = 65535L;
    private static final int HALF_BASE = 65536;
    private static final long HALF_SHIFT = 10L;
    private static final long HALF_MASK = 1023L;

    public static byte[] fromStringAsBytes(String source2) {
        if (source2 == null) {
            return null;
        }
        UnicodeUtil.UTF8Result result2 = Unicode.unsafeFromStringAsUtf8(source2);
        return Arrays.copyOfRange(result2.result, 0, result2.length);
    }

    public static UnicodeUtil.UTF8Result fromStringAsUtf8(String source2) {
        if (source2 == null) {
            return null;
        }
        UnicodeUtil.UTF8Result result2 = new UnicodeUtil.UTF8Result();
        UnicodeUtil.UTF16toUTF8(source2, 0, source2.length(), result2);
        return result2;
    }

    public static void fromStringAsUtf8(String source2, UnicodeUtil.UTF8Result result2) {
        if (source2 == null) {
            result2.length = 0;
            return;
        }
        UnicodeUtil.UTF16toUTF8(source2, 0, source2.length(), result2);
    }

    public static UnicodeUtil.UTF8Result unsafeFromStringAsUtf8(String source2) {
        if (source2 == null) {
            return null;
        }
        UnicodeUtil.UTF8Result result2 = cachedUtf8Result.get().get();
        UnicodeUtil.UTF16toUTF8(source2, 0, source2.length(), result2);
        return result2;
    }

    public static String fromBytes(byte[] source2) {
        return Unicode.fromBytes(source2, 0, source2.length);
    }

    public static String fromBytes(byte[] source2, int offset2, int length2) {
        if (source2 == null) {
            return null;
        }
        UTF16Result result2 = Unicode.unsafeFromBytesAsUtf16(source2, offset2, length2);
        return new String(result2.result, 0, result2.length);
    }

    public static UTF16Result fromBytesAsUtf16(byte[] source2) {
        return Unicode.fromBytesAsUtf16(source2, 0, source2.length);
    }

    public static UTF16Result fromBytesAsUtf16(byte[] source2, int offset2, int length2) {
        if (source2 == null) {
            return null;
        }
        UTF16Result result2 = new UTF16Result();
        Unicode.UTF8toUTF16(source2, offset2, length2, result2);
        return result2;
    }

    public static UTF16Result unsafeFromBytesAsUtf16(byte[] source2) {
        return Unicode.unsafeFromBytesAsUtf16(source2, 0, source2.length);
    }

    public static UTF16Result unsafeFromBytesAsUtf16(byte[] source2, int offset2, int length2) {
        if (source2 == null) {
            return null;
        }
        UTF16Result result2 = cachedUtf16Result.get().get();
        Unicode.UTF8toUTF16(source2, offset2, length2, result2);
        return result2;
    }

    public static void UTF8toUTF16(byte[] utf8, int offset2, int length2, UTF16Result result2) {
        int end2 = offset2 + length2;
        char[] out = result2.result;
        int upto2 = offset2;
        int outUpto = 0;
        if (outUpto + length2 >= out.length) {
            char[] newOut = new char[2 * (outUpto + length2)];
            System.arraycopy(out, 0, newOut, 0, outUpto);
            out = newOut;
            result2.result = newOut;
        }
        while (upto2 < end2) {
            int ch;
            int b = utf8[upto2] & 0xFF;
            ++upto2;
            if (b < 192) {
                assert (b < 128);
                ch = b;
            } else if (b < 224) {
                ch = ((b & 0x1F) << 6) + (utf8[upto2] & 0x3F);
                ++upto2;
            } else if (b < 240) {
                ch = ((b & 0xF) << 12) + ((utf8[upto2] & 0x3F) << 6) + (utf8[upto2 + 1] & 0x3F);
                upto2 += 2;
            } else {
                assert (b < 248);
                ch = ((b & 7) << 18) + ((utf8[upto2] & 0x3F) << 12) + ((utf8[upto2 + 1] & 0x3F) << 6) + (utf8[upto2 + 2] & 0x3F);
                upto2 += 3;
            }
            if ((long)ch <= 65535L) {
                out[outUpto++] = (char)ch;
                continue;
            }
            int chHalf = ch - 65536;
            out[outUpto++] = (char)((chHalf >> 10) + 55296);
            out[outUpto++] = (char)(((long)chHalf & 0x3FFL) + 56320L);
        }
        result2.length = outUpto;
    }

    public static final class UTF16Result {
        public char[] result = new char[10];
        public int length;

        public void setLength(int newLength) {
            if (this.result.length < newLength) {
                char[] newArray = new char[(int)(1.5 * (double)newLength)];
                System.arraycopy(this.result, 0, newArray, 0, this.length);
                this.result = newArray;
            }
            this.length = newLength;
        }

        public void copyText(UTF16Result other) {
            this.setLength(other.length);
            System.arraycopy(other.result, 0, this.result, 0, this.length);
        }
    }
}

