/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.collect;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.elasticsearch.common.annotations.GwtCompatible;
import org.elasticsearch.common.base.Objects;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.base.Predicate;
import org.elasticsearch.common.base.Predicates;
import org.elasticsearch.common.collect.AbstractIterator;
import org.elasticsearch.common.collect.Collections2;
import org.elasticsearch.common.collect.FilteredMultimap;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Multimap;
import org.elasticsearch.common.collect.Multimaps;
import org.elasticsearch.common.collect.Multiset;
import org.elasticsearch.common.collect.Multisets;
import org.elasticsearch.common.collect.SetMultimap;
import org.elasticsearch.common.collect.Sets;

@GwtCompatible
class FilteredEntryMultimap<K, V>
extends FilteredMultimap<K, V> {
    final Predicate<? super Map.Entry<K, V>> predicate;

    FilteredEntryMultimap(Multimap<K, V> unfiltered, Predicate<? super Map.Entry<K, V>> predicate) {
        super(unfiltered);
        this.predicate = Preconditions.checkNotNull(predicate);
    }

    @Override
    Predicate<? super Map.Entry<K, V>> entryPredicate() {
        return this.predicate;
    }

    @Override
    public int size() {
        return this.entries().size();
    }

    private boolean satisfies(K key2, V value2) {
        return this.predicate.apply(Maps.immutableEntry(key2, value2));
    }

    static <E> Collection<E> filterCollection(Collection<E> collection, Predicate<? super E> predicate) {
        if (collection instanceof Set) {
            return Sets.filter((Set)collection, predicate);
        }
        return Collections2.filter(collection, predicate);
    }

    @Override
    public boolean containsKey(@Nullable Object key2) {
        return this.asMap().get(key2) != null;
    }

    @Override
    public Collection<V> removeAll(@Nullable Object key2) {
        return Objects.firstNonNull(this.asMap().remove(key2), this.unmodifiableEmptyCollection());
    }

    Collection<V> unmodifiableEmptyCollection() {
        return this.unfiltered instanceof SetMultimap ? Collections.emptySet() : Collections.emptyList();
    }

    @Override
    public void clear() {
        this.entries().clear();
    }

    @Override
    public Collection<V> get(K key2) {
        return FilteredEntryMultimap.filterCollection(this.unfiltered.get(key2), new ValuePredicate(key2));
    }

    @Override
    Collection<Map.Entry<K, V>> createEntries() {
        return FilteredEntryMultimap.filterCollection(this.unfiltered.entries(), this.predicate);
    }

    @Override
    Iterator<Map.Entry<K, V>> entryIterator() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    Map<K, Collection<V>> createAsMap() {
        return new AsMap();
    }

    @Override
    public Set<K> keySet() {
        return this.asMap().keySet();
    }

    boolean removeIf(Predicate<? super Map.Entry<K, Collection<V>>> predicate) {
        Iterator entryIterator = this.unfiltered.asMap().entrySet().iterator();
        boolean changed = false;
        while (entryIterator.hasNext()) {
            Map.Entry entry = entryIterator.next();
            Object key2 = entry.getKey();
            Collection collection = FilteredEntryMultimap.filterCollection(entry.getValue(), new ValuePredicate(key2));
            if (collection.isEmpty() || !predicate.apply(Maps.immutableEntry(key2, collection))) continue;
            if (collection.size() == entry.getValue().size()) {
                entryIterator.remove();
            } else {
                collection.clear();
            }
            changed = true;
        }
        return changed;
    }

    @Override
    Multiset<K> createKeys() {
        return new Keys();
    }

    class Keys
    extends Multimaps.Keys<K, V> {
        Keys() {
            super(FilteredEntryMultimap.this);
        }

        @Override
        public int remove(@Nullable Object key2, int occurrences) {
            Multisets.checkNonnegative(occurrences, "occurrences");
            if (occurrences == 0) {
                return this.count(key2);
            }
            Collection collection = FilteredEntryMultimap.this.unfiltered.asMap().get(key2);
            if (collection == null) {
                return 0;
            }
            Object k = key2;
            int oldCount = 0;
            Iterator itr = collection.iterator();
            while (itr.hasNext()) {
                Object v = itr.next();
                if (!FilteredEntryMultimap.this.satisfies(k, v) || ++oldCount > occurrences) continue;
                itr.remove();
            }
            return oldCount;
        }

        @Override
        public Set<Multiset.Entry<K>> entrySet() {
            return new Multisets.EntrySet<K>(){

                @Override
                Multiset<K> multiset() {
                    return Keys.this;
                }

                @Override
                public Iterator<Multiset.Entry<K>> iterator() {
                    return Keys.this.entryIterator();
                }

                @Override
                public int size() {
                    return FilteredEntryMultimap.this.keySet().size();
                }

                @Override
                private boolean removeIf(final Predicate<? super Multiset.Entry<K>> predicate) {
                    return FilteredEntryMultimap.this.removeIf(new Predicate<Map.Entry<K, Collection<V>>>(){

                        @Override
                        public boolean apply(Map.Entry<K, Collection<V>> entry) {
                            return predicate.apply(Multisets.immutableEntry(entry.getKey(), entry.getValue().size()));
                        }
                    });
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    return this.removeIf(Predicates.in(c));
                }

                @Override
                public boolean retainAll(Collection<?> c) {
                    return this.removeIf(Predicates.not(Predicates.in(c)));
                }
            };
        }
    }

    class AsMap
    extends AbstractMap<K, Collection<V>> {
        private Set<K> keySet;

        AsMap() {
        }

        @Override
        public boolean containsKey(@Nullable Object key2) {
            return this.get(key2) != null;
        }

        @Override
        public void clear() {
            FilteredEntryMultimap.this.clear();
        }

        @Override
        public Collection<V> get(@Nullable Object key2) {
            Collection result2 = FilteredEntryMultimap.this.unfiltered.asMap().get(key2);
            if (result2 == null) {
                return null;
            }
            Object k = key2;
            return (result2 = FilteredEntryMultimap.filterCollection(result2, new ValuePredicate(k))).isEmpty() ? null : result2;
        }

        @Override
        public Collection<V> remove(@Nullable Object key2) {
            Collection collection = FilteredEntryMultimap.this.unfiltered.asMap().get(key2);
            if (collection == null) {
                return null;
            }
            Object k = key2;
            ArrayList result2 = Lists.newArrayList();
            Iterator itr = collection.iterator();
            while (itr.hasNext()) {
                Object v = itr.next();
                if (!FilteredEntryMultimap.this.satisfies(k, v)) continue;
                itr.remove();
                result2.add(v);
            }
            if (result2.isEmpty()) {
                return null;
            }
            if (FilteredEntryMultimap.this.unfiltered instanceof SetMultimap) {
                return Collections.unmodifiableSet(Sets.newLinkedHashSet(result2));
            }
            return Collections.unmodifiableList(result2);
        }

        @Override
        public Set<K> keySet() {
            Set result2 = this.keySet;
            if (result2 == null) {
                this.keySet = new Maps.KeySet<K, Collection<V>>(){

                    @Override
                    Map<K, Collection<V>> map() {
                        return AsMap.this;
                    }

                    @Override
                    public boolean removeAll(Collection<?> c) {
                        return FilteredEntryMultimap.this.removeIf(Predicates.compose(Predicates.in(c), Maps.keyFunction()));
                    }

                    @Override
                    public boolean retainAll(Collection<?> c) {
                        return FilteredEntryMultimap.this.removeIf(Predicates.compose(Predicates.not(Predicates.in(c)), Maps.keyFunction()));
                    }

                    @Override
                    public boolean remove(@Nullable Object o) {
                        return AsMap.this.remove(o) != null;
                    }
                };
                return this.keySet;
            }
            return result2;
        }

        @Override
        public Set<Map.Entry<K, Collection<V>>> entrySet() {
            return new Maps.EntrySet<K, Collection<V>>(){

                @Override
                Map<K, Collection<V>> map() {
                    return AsMap.this;
                }

                @Override
                public Iterator<Map.Entry<K, Collection<V>>> iterator() {
                    return new AbstractIterator<Map.Entry<K, Collection<V>>>(){
                        final Iterator<Map.Entry<K, Collection<V>>> backingIterator;
                        {
                            this.backingIterator = FilteredEntryMultimap.this.unfiltered.asMap().entrySet().iterator();
                        }

                        @Override
                        protected Map.Entry<K, Collection<V>> computeNext() {
                            while (this.backingIterator.hasNext()) {
                                Map.Entry entry = this.backingIterator.next();
                                Object key2 = entry.getKey();
                                Collection collection = FilteredEntryMultimap.filterCollection(entry.getValue(), new ValuePredicate(key2));
                                if (collection.isEmpty()) continue;
                                return Maps.immutableEntry(key2, collection);
                            }
                            return (Map.Entry)this.endOfData();
                        }
                    };
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    return FilteredEntryMultimap.this.removeIf(Predicates.in(c));
                }

                @Override
                public boolean retainAll(Collection<?> c) {
                    return FilteredEntryMultimap.this.removeIf(Predicates.not(Predicates.in(c)));
                }

                @Override
                public int size() {
                    return Iterators.size(this.iterator());
                }
            };
        }

        @Override
        public Collection<Collection<V>> values() {
            return new Maps.Values<K, Collection<V>>(){

                @Override
                Map<K, Collection<V>> map() {
                    return AsMap.this;
                }

                @Override
                public boolean remove(@Nullable Object o) {
                    if (o instanceof Collection) {
                        Collection c = (Collection)o;
                        Iterator entryIterator = FilteredEntryMultimap.this.unfiltered.asMap().entrySet().iterator();
                        while (entryIterator.hasNext()) {
                            Map.Entry entry = entryIterator.next();
                            Object key2 = entry.getKey();
                            Collection collection = FilteredEntryMultimap.filterCollection(entry.getValue(), new ValuePredicate(key2));
                            if (collection.isEmpty() || !c.equals(collection)) continue;
                            if (collection.size() == entry.getValue().size()) {
                                entryIterator.remove();
                            } else {
                                collection.clear();
                            }
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public boolean removeAll(Collection<?> c) {
                    return FilteredEntryMultimap.this.removeIf(Predicates.compose(Predicates.in(c), Maps.valueFunction()));
                }

                @Override
                public boolean retainAll(Collection<?> c) {
                    return FilteredEntryMultimap.this.removeIf(Predicates.compose(Predicates.not(Predicates.in(c)), Maps.valueFunction()));
                }
            };
        }
    }

    final class ValuePredicate
    implements Predicate<V> {
        private final K key;

        ValuePredicate(K key2) {
            this.key = key2;
        }

        @Override
        public boolean apply(@Nullable V value2) {
            return FilteredEntryMultimap.this.satisfies(this.key, value2);
        }
    }
}

