/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.collect;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.elasticsearch.common.annotations.Beta;
import org.elasticsearch.common.annotations.GwtCompatible;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.collect.AbstractMapEntry;
import org.elasticsearch.common.collect.ImmutableBiMap;
import org.elasticsearch.common.collect.ImmutableCollection;
import org.elasticsearch.common.collect.ImmutableEntry;
import org.elasticsearch.common.collect.ImmutableEnumMap;
import org.elasticsearch.common.collect.ImmutableMapEntrySet;
import org.elasticsearch.common.collect.ImmutableMapKeySet;
import org.elasticsearch.common.collect.ImmutableMapValues;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.ImmutableSetMultimap;
import org.elasticsearch.common.collect.ImmutableSortedMap;
import org.elasticsearch.common.collect.Iterables;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.RegularImmutableMap;
import org.elasticsearch.common.collect.SingletonImmutableBiMap;
import org.elasticsearch.common.collect.UnmodifiableIterator;

@GwtCompatible(serializable=true, emulated=true)
public abstract class ImmutableMap<K, V>
implements Map<K, V>,
Serializable {
    private transient ImmutableSet<Map.Entry<K, V>> entrySet;
    private transient ImmutableSet<K> keySet;
    private transient ImmutableCollection<V> values;
    private transient ImmutableSetMultimap<K, V> multimapView;

    public static <K, V> ImmutableMap<K, V> of() {
        return ImmutableBiMap.of();
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1) {
        return ImmutableBiMap.of(k1, v1);
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2) {
        return new RegularImmutableMap(ImmutableMap.entryOf(k1, v1), ImmutableMap.entryOf(k2, v2));
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        return new RegularImmutableMap(ImmutableMap.entryOf(k1, v1), ImmutableMap.entryOf(k2, v2), ImmutableMap.entryOf(k3, v3));
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        return new RegularImmutableMap(ImmutableMap.entryOf(k1, v1), ImmutableMap.entryOf(k2, v2), ImmutableMap.entryOf(k3, v3), ImmutableMap.entryOf(k4, v4));
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        return new RegularImmutableMap(ImmutableMap.entryOf(k1, v1), ImmutableMap.entryOf(k2, v2), ImmutableMap.entryOf(k3, v3), ImmutableMap.entryOf(k4, v4), ImmutableMap.entryOf(k5, v5));
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    static <K, V> Map.Entry<K, V> entryOf(K key2, V value2) {
        Preconditions.checkNotNull(key2, "null key in entry: null=%s", value2);
        Preconditions.checkNotNull(value2, "null value in entry: %s=null", key2);
        return Maps.immutableEntry(key2, value2);
    }

    public static <K, V> ImmutableMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        if (map instanceof ImmutableMap && !(map instanceof ImmutableSortedMap)) {
            ImmutableMap kvMap = (ImmutableMap)map;
            if (!kvMap.isPartialView()) {
                return kvMap;
            }
        } else if (map instanceof EnumMap) {
            EnumMap enumMap = (EnumMap)map;
            for (Map.Entry entry : enumMap.entrySet()) {
                Preconditions.checkNotNull(entry.getKey());
                Preconditions.checkNotNull(entry.getValue());
            }
            ImmutableMap result2 = ImmutableEnumMap.asImmutable(new EnumMap(enumMap));
            return result2;
        }
        Map.Entry[] entries2 = map.entrySet().toArray(new Map.Entry[0]);
        switch (entries2.length) {
            case 0: {
                return ImmutableMap.of();
            }
            case 1: {
                return new SingletonImmutableBiMap(ImmutableMap.entryOf(entries2[0].getKey(), entries2[0].getValue()));
            }
        }
        for (int i2 = 0; i2 < entries2.length; ++i2) {
            Object k = entries2[i2].getKey();
            Object v = entries2[i2].getValue();
            entries2[i2] = ImmutableMap.entryOf(k, v);
        }
        return new RegularImmutableMap(entries2);
    }

    ImmutableMap() {
    }

    @Override
    @Deprecated
    public final V put(K k, V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(@Nullable Object key2) {
        return this.get(key2) != null;
    }

    @Override
    public boolean containsValue(@Nullable Object value2) {
        return value2 != null && Maps.containsValueImpl(this, value2);
    }

    @Override
    public abstract V get(@Nullable Object var1);

    @Override
    public ImmutableSet<Map.Entry<K, V>> entrySet() {
        ImmutableSet<Map.Entry<K, V>> result2 = this.entrySet;
        return result2 == null ? (this.entrySet = this.createEntrySet()) : result2;
    }

    abstract ImmutableSet<Map.Entry<K, V>> createEntrySet();

    @Override
    public ImmutableSet<K> keySet() {
        ImmutableSet<K> result2 = this.keySet;
        return result2 == null ? (this.keySet = this.createKeySet()) : result2;
    }

    ImmutableSet<K> createKeySet() {
        return new ImmutableMapKeySet(this);
    }

    @Override
    public ImmutableCollection<V> values() {
        ImmutableCollection<V> result2 = this.values;
        return result2 == null ? (this.values = new ImmutableMapValues(this)) : result2;
    }

    @Beta
    public ImmutableSetMultimap<K, V> asMultimap() {
        ImmutableSetMultimap<K, V> result2 = this.multimapView;
        return result2 == null ? (this.multimapView = this.createMultimapView()) : result2;
    }

    private ImmutableSetMultimap<K, V> createMultimapView() {
        ImmutableMap<K, ImmutableSet<V>> map = this.viewMapValuesAsSingletonSets();
        return new ImmutableSetMultimap<K, V>(map, map.size(), null);
    }

    private ImmutableMap<K, ImmutableSet<V>> viewMapValuesAsSingletonSets() {
        class MapViewOfValuesAsSingletonSets
        extends ImmutableMap<K, ImmutableSet<V>> {
            MapViewOfValuesAsSingletonSets() {
            }

            @Override
            public int size() {
                return ImmutableMap.this.size();
            }

            @Override
            public boolean containsKey(@Nullable Object key2) {
                return ImmutableMap.this.containsKey(key2);
            }

            @Override
            public ImmutableSet<V> get(@Nullable Object key2) {
                Object outerValue = ImmutableMap.this.get(key2);
                return outerValue == null ? null : ImmutableSet.of(outerValue);
            }

            @Override
            boolean isPartialView() {
                return false;
            }

            @Override
            ImmutableSet<Map.Entry<K, ImmutableSet<V>>> createEntrySet() {
                return new ImmutableMapEntrySet<K, ImmutableSet<V>>(){

                    @Override
                    ImmutableMap<K, ImmutableSet<V>> map() {
                        return this;
                    }

                    @Override
                    public UnmodifiableIterator<Map.Entry<K, ImmutableSet<V>>> iterator() {
                        final Iterator backingIterator = ((ImmutableSet)ImmutableMap.this.entrySet()).iterator();
                        return new UnmodifiableIterator<Map.Entry<K, ImmutableSet<V>>>(){

                            @Override
                            public boolean hasNext() {
                                return backingIterator.hasNext();
                            }

                            @Override
                            public Map.Entry<K, ImmutableSet<V>> next() {
                                final Map.Entry backingEntry = (Map.Entry)backingIterator.next();
                                return new AbstractMapEntry<K, ImmutableSet<V>>(){

                                    @Override
                                    public K getKey() {
                                        return backingEntry.getKey();
                                    }

                                    @Override
                                    public ImmutableSet<V> getValue() {
                                        return ImmutableSet.of(backingEntry.getValue());
                                    }
                                };
                            }
                        };
                    }
                };
            }
        }
        return new MapViewOfValuesAsSingletonSets();
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return Maps.equalsImpl(this, object);
    }

    abstract boolean isPartialView();

    @Override
    public int hashCode() {
        return ((ImmutableSet)this.entrySet()).hashCode();
    }

    public String toString() {
        return Maps.toStringImpl(this);
    }

    Object writeReplace() {
        return new SerializedForm(this);
    }

    static class SerializedForm
    implements Serializable {
        private final Object[] keys;
        private final Object[] values;
        private static final long serialVersionUID = 0L;

        SerializedForm(ImmutableMap<?, ?> map) {
            this.keys = new Object[map.size()];
            this.values = new Object[map.size()];
            int i2 = 0;
            for (Map.Entry entry : map.entrySet()) {
                this.keys[i2] = entry.getKey();
                this.values[i2] = entry.getValue();
                ++i2;
            }
        }

        Object readResolve() {
            Builder<Object, Object> builder = new Builder<Object, Object>();
            return this.createMap(builder);
        }

        Object createMap(Builder<Object, Object> builder) {
            for (int i2 = 0; i2 < this.keys.length; ++i2) {
                builder.put(this.keys[i2], this.values[i2]);
            }
            return builder.build();
        }
    }

    public static class Builder<K, V> {
        final ArrayList<Map.Entry<K, V>> entries = Lists.newArrayList();

        public Builder<K, V> put(K key2, V value2) {
            this.entries.add(ImmutableMap.entryOf(key2, value2));
            return this;
        }

        public Builder<K, V> put(Map.Entry<? extends K, ? extends V> entry) {
            K key2 = entry.getKey();
            V value2 = entry.getValue();
            if (entry instanceof ImmutableEntry) {
                Preconditions.checkNotNull(key2);
                Preconditions.checkNotNull(value2);
                Map.Entry<K, V> immutableEntry = entry;
                this.entries.add(immutableEntry);
            } else {
                this.entries.add(ImmutableMap.entryOf(key2, value2));
            }
            return this;
        }

        public Builder<K, V> putAll(Map<? extends K, ? extends V> map) {
            this.entries.ensureCapacity(this.entries.size() + map.size());
            for (Map.Entry<K, V> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public ImmutableMap<K, V> build() {
            return Builder.fromEntryList(this.entries);
        }

        private static <K, V> ImmutableMap<K, V> fromEntryList(List<Map.Entry<K, V>> entries2) {
            int size2 = entries2.size();
            switch (size2) {
                case 0: {
                    return ImmutableMap.of();
                }
                case 1: {
                    return new SingletonImmutableBiMap<K, V>(Iterables.getOnlyElement(entries2));
                }
            }
            Map.Entry[] entryArray = entries2.toArray(new Map.Entry[entries2.size()]);
            return new RegularImmutableMap(entryArray);
        }
    }
}

