/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.collect;

import java.util.Map;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Maps;

public class MapBuilder<K, V> {
    private Map<K, V> map = Maps.newHashMap();

    public static <K, V> MapBuilder<K, V> newMapBuilder() {
        return new MapBuilder<K, V>();
    }

    public static <K, V> MapBuilder<K, V> newMapBuilder(Map<K, V> map) {
        return new MapBuilder<K, V>(map);
    }

    public MapBuilder() {
        this.map = Maps.newHashMap();
    }

    public MapBuilder(Map<K, V> map) {
        this.map = Maps.newHashMap(map);
    }

    public MapBuilder<K, V> putAll(Map<K, V> map) {
        this.map.putAll(map);
        return this;
    }

    public MapBuilder<K, V> put(K key2, V value2) {
        this.map.put(key2, value2);
        return this;
    }

    public MapBuilder<K, V> remove(K key2) {
        this.map.remove(key2);
        return this;
    }

    public MapBuilder<K, V> clear() {
        this.map.clear();
        return this;
    }

    public V get(K key2) {
        return this.map.get(key2);
    }

    public boolean containsKey(K key2) {
        return this.map.containsKey(key2);
    }

    public Map<K, V> map() {
        return this.map;
    }

    public ImmutableMap<K, V> immutableMap() {
        return ImmutableMap.copyOf(this.map);
    }
}

