/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.collect;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.annotations.GwtCompatible;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Ordering;
import org.elasticsearch.common.collect.ReverseNaturalOrdering;

@GwtCompatible(serializable=true)
final class NaturalOrdering
extends Ordering<Comparable>
implements Serializable {
    static final NaturalOrdering INSTANCE = new NaturalOrdering();
    private static final long serialVersionUID = 0L;

    @Override
    public int compare(Comparable left2, Comparable right) {
        Preconditions.checkNotNull(left2);
        Preconditions.checkNotNull(right);
        if (left2 == right) {
            return 0;
        }
        return left2.compareTo(right);
    }

    @Override
    public <S extends Comparable> Ordering<S> reverse() {
        return ReverseNaturalOrdering.INSTANCE;
    }

    @Override
    public int binarySearch(List<? extends Comparable> sortedList, Comparable key2) {
        return Collections.binarySearch(sortedList, key2);
    }

    @Override
    public <E extends Comparable> List<E> sortedCopy(Iterable<E> iterable) {
        ArrayList<E> list2 = Lists.newArrayList(iterable);
        Collections.sort(list2);
        return list2;
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public String toString() {
        return "Ordering.natural()";
    }

    private NaturalOrdering() {
    }
}

