/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexOutput;
import org.elasticsearch.common.compress.CompressorContext;
import org.elasticsearch.common.trove.iterator.TLongIterator;
import org.elasticsearch.common.trove.list.array.TLongArrayList;

public abstract class CompressedIndexOutput<T extends CompressorContext>
extends IndexOutput {
    final IndexOutput out;
    protected final T context;
    protected byte[] uncompressed;
    protected int uncompressedLength;
    private int position = 0;
    private long uncompressedPosition;
    private boolean closed;
    private final long metaDataPointer;
    private TLongArrayList offsets = new TLongArrayList();

    public CompressedIndexOutput(IndexOutput out, T context) throws IOException {
        this.out = out;
        this.context = context;
        this.writeHeader(out);
        out.writeInt(0);
        this.metaDataPointer = out.getFilePointer();
        out.writeLong(-1L);
    }

    public IndexOutput underlying() {
        return this.out;
    }

    @Override
    public void writeByte(byte b) throws IOException {
        if (this.position >= this.uncompressedLength) {
            this.flushBuffer();
        }
        ++this.uncompressedPosition;
        this.uncompressed[this.position++] = b;
    }

    @Override
    public void writeBytes(byte[] input, int offset2, int length2) throws IOException {
        if (length2 == 0) {
            return;
        }
        int BUFFER_LEN = this.uncompressedLength;
        int free2 = BUFFER_LEN - this.position;
        if (free2 >= length2) {
            System.arraycopy(input, offset2, this.uncompressed, this.position, length2);
            this.position += length2;
            this.uncompressedPosition += (long)length2;
            return;
        }
        if (this.position > 0) {
            System.arraycopy(input, offset2, this.uncompressed, this.position, free2);
            this.position += free2;
            this.uncompressedPosition += (long)free2;
            this.flushBuffer();
            offset2 += free2;
            length2 -= free2;
        }
        while (length2 >= BUFFER_LEN) {
            this.offsets.add(this.out.getFilePointer());
            this.compress(input, offset2, BUFFER_LEN, this.out);
            offset2 += BUFFER_LEN;
            length2 -= BUFFER_LEN;
            this.uncompressedPosition += (long)BUFFER_LEN;
        }
        if (length2 > 0) {
            System.arraycopy(input, offset2, this.uncompressed, 0, length2);
        }
        this.position = length2;
        this.uncompressedPosition += (long)length2;
    }

    @Override
    public void copyBytes(DataInput input, long length2) throws IOException {
        int BUFFER_LEN = this.uncompressedLength;
        int free2 = BUFFER_LEN - this.position;
        if ((long)free2 >= length2) {
            input.readBytes(this.uncompressed, this.position, (int)length2, false);
            this.position = (int)((long)this.position + length2);
            this.uncompressedPosition += length2;
            return;
        }
        if (this.position > 0) {
            input.readBytes(this.uncompressed, this.position, free2, false);
            this.position += free2;
            this.uncompressedPosition += (long)free2;
            this.flushBuffer();
            length2 -= (long)free2;
        }
        while (length2 >= (long)BUFFER_LEN) {
            this.offsets.add(this.out.getFilePointer());
            input.readBytes(this.uncompressed, 0, BUFFER_LEN);
            this.compress(this.uncompressed, 0, BUFFER_LEN, this.out);
            length2 -= (long)BUFFER_LEN;
            this.uncompressedPosition += (long)BUFFER_LEN;
        }
        if (length2 > 0L) {
            input.readBytes(this.uncompressed, 0, (int)length2, false);
        }
        this.position = (int)length2;
        this.uncompressedPosition += length2;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.flushBuffer();
            long metaDataPointerValue = this.out.getFilePointer();
            this.out.writeVLong(this.uncompressedPosition);
            this.out.writeVInt(this.offsets.size());
            TLongIterator it = this.offsets.iterator();
            while (it.hasNext()) {
                this.out.writeVLong(it.next());
            }
            this.out.seek(this.metaDataPointer);
            this.out.writeLong(metaDataPointerValue);
            this.closed = true;
            this.doClose();
            this.out.close();
        }
    }

    protected abstract void doClose() throws IOException;

    @Override
    public long getFilePointer() {
        return this.uncompressedPosition;
    }

    @Override
    public void seek(long pos2) throws IOException {
        throw new IOException("seek not supported on compressed output");
    }

    @Override
    public long length() throws IOException {
        return this.uncompressedPosition;
    }

    private void flushBuffer() throws IOException {
        if (this.position > 0) {
            this.offsets.add(this.out.getFilePointer());
            this.compress(this.uncompressed, 0, this.position, this.out);
            this.position = 0;
        }
    }

    protected abstract void writeHeader(IndexOutput var1) throws IOException;

    protected abstract void compress(byte[] var1, int var2, int var3, IndexOutput var4) throws IOException;
}

