/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.lucene.store.IndexInput;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.compress.CompressedStreamInput;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.lzf.LZFCompressor;
import org.elasticsearch.common.compress.snappy.UnavailableSnappyCompressor;
import org.elasticsearch.common.compress.snappy.xerial.XerialSnappy;
import org.elasticsearch.common.compress.snappy.xerial.XerialSnappyCompressor;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.CachedStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.settings.Settings;

public class CompressorFactory {
    private static final LZFCompressor LZF = new LZFCompressor();
    private static final Compressor[] compressors;
    private static final ImmutableMap<String, Compressor> compressorsByType;
    private static Compressor defaultCompressor;

    public static synchronized void configure(Settings settings) {
        for (Compressor compressor : compressors) {
            compressor.configure(settings);
        }
        String defaultType = settings.get("compress.default.type", "lzf").toLowerCase(Locale.ENGLISH);
        boolean found = false;
        for (Compressor compressor : compressors) {
            if (!defaultType.equalsIgnoreCase(compressor.type())) continue;
            defaultCompressor = compressor;
            found = true;
            break;
        }
        if (!found) {
            Loggers.getLogger(CompressorFactory.class).warn("failed to find default type [{}]", defaultType);
        }
    }

    public static synchronized void setDefaultCompressor(Compressor defaultCompressor) {
        CompressorFactory.defaultCompressor = defaultCompressor;
    }

    public static Compressor defaultCompressor() {
        return defaultCompressor;
    }

    public static boolean isCompressed(BytesReference bytes2) {
        return CompressorFactory.compressor(bytes2) != null;
    }

    public static boolean isCompressed(byte[] data2) {
        return CompressorFactory.compressor(data2, 0, data2.length) != null;
    }

    public static boolean isCompressed(byte[] data2, int offset2, int length2) {
        return CompressorFactory.compressor(data2, offset2, length2) != null;
    }

    public static boolean isCompressed(IndexInput in) throws IOException {
        return CompressorFactory.compressor(in) != null;
    }

    @Nullable
    public static Compressor compressor(BytesReference bytes2) {
        for (Compressor compressor : compressors) {
            if (!compressor.isCompressed(bytes2)) continue;
            return compressor;
        }
        return null;
    }

    @Nullable
    public static Compressor compressor(byte[] data2) {
        return CompressorFactory.compressor(data2, 0, data2.length);
    }

    @Nullable
    public static Compressor compressor(byte[] data2, int offset2, int length2) {
        for (Compressor compressor : compressors) {
            if (!compressor.isCompressed(data2, offset2, length2)) continue;
            return compressor;
        }
        return null;
    }

    @Nullable
    public static Compressor compressor(ChannelBuffer buffer) {
        for (Compressor compressor : compressors) {
            if (!compressor.isCompressed(buffer)) continue;
            return compressor;
        }
        return null;
    }

    @Nullable
    public static Compressor compressor(IndexInput in) throws IOException {
        for (Compressor compressor : compressors) {
            if (!compressor.isCompressed(in)) continue;
            return compressor;
        }
        return null;
    }

    public static Compressor compressor(String type2) {
        return compressorsByType.get(type2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BytesReference uncompressIfNeeded(BytesReference bytes2) throws IOException {
        Compressor compressor = CompressorFactory.compressor(bytes2);
        if (compressor != null) {
            if (bytes2.hasArray()) {
                return new BytesArray(compressor.uncompress(bytes2.array(), bytes2.arrayOffset(), bytes2.length()));
            }
            CompressedStreamInput compressed = compressor.streamInput(bytes2.streamInput());
            CachedStreamOutput.Entry entry = CachedStreamOutput.popEntry();
            try {
                Streams.copy(compressed, (OutputStream)entry.bytes());
                ((StreamInput)compressed).close();
                BytesArray bytesArray = new BytesArray(entry.bytes().bytes().toBytes());
                return bytesArray;
            }
            finally {
                CachedStreamOutput.pushEntry(entry);
            }
        }
        return bytes2;
    }

    static {
        ArrayList<Compressor> compressorsX = Lists.newArrayList();
        compressorsX.add(LZF);
        boolean addedSnappy = false;
        if (XerialSnappy.available) {
            compressorsX.add(new XerialSnappyCompressor());
            addedSnappy = true;
        } else {
            Loggers.getLogger(CompressorFactory.class).debug("failed to load xerial snappy-java", XerialSnappy.failure, new Object[0]);
        }
        if (!addedSnappy) {
            compressorsX.add(new UnavailableSnappyCompressor());
        }
        compressors = compressorsX.toArray(new Compressor[compressorsX.size()]);
        MapBuilder<String, Compressor> compressorsByTypeX = MapBuilder.newMapBuilder();
        for (Compressor compressor : compressors) {
            compressorsByTypeX.put(compressor.type(), compressor);
        }
        compressorsByType = compressorsByTypeX.immutableMap();
        defaultCompressor = LZF;
    }
}

