/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.snappy.xerial;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.elasticsearch.common.compress.snappy.SnappyCompressedIndexInput;
import org.elasticsearch.common.compress.snappy.SnappyCompressorContext;
import org.xerial.snappy.Snappy;

public class XerialSnappyCompressedIndexInput
extends SnappyCompressedIndexInput {
    public XerialSnappyCompressedIndexInput(IndexInput in, SnappyCompressorContext context) throws IOException {
        super(in, context);
    }

    @Override
    protected int uncompress(IndexInput in, byte[] out) throws IOException {
        boolean compressed = in.readByte() != 0;
        int length2 = in.readVInt();
        if (!compressed) {
            in.readBytes(out, 0, length2);
            return length2;
        }
        in.readBytes(this.inputBuffer, 0, length2);
        return Snappy.rawUncompress(this.inputBuffer, 0, length2, out, 0);
    }
}

