/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.jts.JtsGeometry;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class GeoJSONShapeSerializer {
    private GeoJSONShapeSerializer() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void serialize(Shape shape, XContentBuilder builder) throws IOException {
        if (shape instanceof JtsGeometry) {
            Geometry geometry = ((JtsGeometry)shape).getGeom();
            if (geometry instanceof Point) {
                GeoJSONShapeSerializer.serializePoint((Point)geometry, builder);
                return;
            } else if (geometry instanceof LineString) {
                GeoJSONShapeSerializer.serializeLineString((LineString)geometry, builder);
                return;
            } else if (geometry instanceof Polygon) {
                GeoJSONShapeSerializer.serializePolygon((Polygon)geometry, builder);
                return;
            } else if (geometry instanceof MultiPoint) {
                GeoJSONShapeSerializer.serializeMultiPoint((MultiPoint)geometry, builder);
                return;
            } else {
                if (!(geometry instanceof MultiPolygon)) throw new ElasticSearchIllegalArgumentException("Geometry type [" + geometry.getGeometryType() + "] not supported");
                GeoJSONShapeSerializer.serializeMulitPolygon((MultiPolygon)geometry, builder);
            }
            return;
        } else if (shape instanceof com.spatial4j.core.shape.Point) {
            GeoJSONShapeSerializer.serializePoint((com.spatial4j.core.shape.Point)shape, builder);
            return;
        } else {
            if (!(shape instanceof Rectangle)) throw new ElasticSearchIllegalArgumentException("Shape type [" + shape.getClass().getSimpleName() + "] not supported");
            GeoJSONShapeSerializer.serializeRectangle((Rectangle)shape, builder);
        }
    }

    private static void serializeRectangle(Rectangle rectangle, XContentBuilder builder) throws IOException {
        builder.field("type", "Envelope").startArray("coordinates").startArray().value(rectangle.getMinX()).value(rectangle.getMaxY()).endArray().startArray().value(rectangle.getMaxX()).value(rectangle.getMinY()).endArray().endArray();
    }

    private static void serializePoint(Point point, XContentBuilder builder) throws IOException {
        builder.field("type", "Point").startArray("coordinates").value(point.getX()).value(point.getY()).endArray();
    }

    private static void serializePoint(com.spatial4j.core.shape.Point point, XContentBuilder builder) throws IOException {
        builder.field("type", "Point").startArray("coordinates").value(point.getX()).value(point.getY()).endArray();
    }

    private static void serializeLineString(LineString lineString, XContentBuilder builder) throws IOException {
        builder.field("type", "LineString").startArray("coordinates");
        for (Coordinate coordinate : lineString.getCoordinates()) {
            GeoJSONShapeSerializer.serializeCoordinate(coordinate, builder);
        }
        builder.endArray();
    }

    private static void serializePolygon(Polygon polygon, XContentBuilder builder) throws IOException {
        builder.field("type", "Polygon").startArray("coordinates");
        GeoJSONShapeSerializer.serializePolygonCoordinates(polygon, builder);
        builder.endArray();
    }

    private static void serializePolygonCoordinates(Polygon polygon, XContentBuilder builder) throws IOException {
        builder.startArray();
        for (Coordinate coordinate : polygon.getExteriorRing().getCoordinates()) {
            GeoJSONShapeSerializer.serializeCoordinate(coordinate, builder);
        }
        builder.endArray();
        for (int i2 = 0; i2 < polygon.getNumInteriorRing(); ++i2) {
            LineString interiorRing = polygon.getInteriorRingN(i2);
            builder.startArray();
            for (Coordinate coordinate : interiorRing.getCoordinates()) {
                GeoJSONShapeSerializer.serializeCoordinate(coordinate, builder);
            }
            builder.endArray();
        }
    }

    private static void serializeMulitPolygon(MultiPolygon multiPolygon, XContentBuilder builder) throws IOException {
        builder.field("type", "MultiPolygon").startArray("coordinates");
        for (int i2 = 0; i2 < multiPolygon.getNumGeometries(); ++i2) {
            builder.startArray();
            GeoJSONShapeSerializer.serializePolygonCoordinates((Polygon)multiPolygon.getGeometryN(i2), builder);
            builder.endArray();
        }
        builder.endArray();
    }

    private static void serializeMultiPoint(MultiPoint multiPoint, XContentBuilder builder) throws IOException {
        builder.field("type", "MultiPoint").startArray("coordinates");
        for (Coordinate coordinate : multiPoint.getCoordinates()) {
            GeoJSONShapeSerializer.serializeCoordinate(coordinate, builder);
        }
        builder.endArray();
    }

    private static void serializeCoordinate(Coordinate coordinate, XContentBuilder builder) throws IOException {
        builder.startArray().value(coordinate.x).value(coordinate.y).endArray();
    }
}

