/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import java.lang.annotation.Annotation;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.MembersInjector;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.Scope;
import org.elasticsearch.common.inject.Stage;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.binder.AnnotatedBindingBuilder;
import org.elasticsearch.common.inject.binder.AnnotatedConstantBindingBuilder;
import org.elasticsearch.common.inject.binder.LinkedBindingBuilder;
import org.elasticsearch.common.inject.matcher.Matcher;
import org.elasticsearch.common.inject.spi.Message;
import org.elasticsearch.common.inject.spi.TypeConverter;
import org.elasticsearch.common.inject.spi.TypeListener;

public abstract class AbstractModule
implements Module {
    Binder binder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized void configure(Binder builder) {
        Preconditions.checkState(this.binder == null, "Re-entry is not allowed.");
        this.binder = Preconditions.checkNotNull(builder, "builder");
        try {
            this.configure();
        }
        finally {
            this.binder = null;
        }
    }

    protected abstract void configure();

    protected Binder binder() {
        return this.binder;
    }

    protected void bindScope(Class<? extends Annotation> scopeAnnotation, Scope scope) {
        this.binder.bindScope(scopeAnnotation, scope);
    }

    protected <T> LinkedBindingBuilder<T> bind(Key<T> key2) {
        return this.binder.bind(key2);
    }

    protected <T> AnnotatedBindingBuilder<T> bind(TypeLiteral<T> typeLiteral) {
        return this.binder.bind(typeLiteral);
    }

    protected <T> AnnotatedBindingBuilder<T> bind(Class<T> clazz) {
        return this.binder.bind(clazz);
    }

    protected AnnotatedConstantBindingBuilder bindConstant() {
        return this.binder.bindConstant();
    }

    protected void install(Module module) {
        this.binder.install(module);
    }

    protected void addError(String message2, Object ... arguments) {
        this.binder.addError(message2, arguments);
    }

    protected void addError(Throwable t) {
        this.binder.addError(t);
    }

    protected void addError(Message message2) {
        this.binder.addError(message2);
    }

    protected void requestInjection(Object instance) {
        this.binder.requestInjection(instance);
    }

    protected void requestStaticInjection(Class<?> ... types) {
        this.binder.requestStaticInjection(types);
    }

    protected void requireBinding(Key<?> key2) {
        this.binder.getProvider(key2);
    }

    protected void requireBinding(Class<?> type2) {
        this.binder.getProvider(type2);
    }

    protected <T> Provider<T> getProvider(Key<T> key2) {
        return this.binder.getProvider(key2);
    }

    protected <T> Provider<T> getProvider(Class<T> type2) {
        return this.binder.getProvider(type2);
    }

    protected void convertToTypes(Matcher<? super TypeLiteral<?>> typeMatcher, TypeConverter converter) {
        this.binder.convertToTypes(typeMatcher, converter);
    }

    protected Stage currentStage() {
        return this.binder.currentStage();
    }

    protected <T> MembersInjector<T> getMembersInjector(Class<T> type2) {
        return this.binder.getMembersInjector(type2);
    }

    protected <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> type2) {
        return this.binder.getMembersInjector(type2);
    }

    protected void bindListener(Matcher<? super TypeLiteral<?>> typeMatcher, TypeListener listener) {
        this.binder.bindListener(typeMatcher, listener);
    }
}

