/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import java.lang.reflect.InvocationTargetException;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.inject.ConstructionProxy;
import org.elasticsearch.common.inject.MembersInjectorImpl;
import org.elasticsearch.common.inject.SingleParameterInjector;
import org.elasticsearch.common.inject.internal.ConstructionContext;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.internal.ErrorsException;
import org.elasticsearch.common.inject.internal.InternalContext;
import org.elasticsearch.common.inject.spi.InjectionPoint;

class ConstructorInjector<T> {
    private final ImmutableSet<InjectionPoint> injectableMembers;
    private final SingleParameterInjector<?>[] parameterInjectors;
    private final ConstructionProxy<T> constructionProxy;
    private final MembersInjectorImpl<T> membersInjector;

    ConstructorInjector(ImmutableSet<InjectionPoint> injectableMembers, ConstructionProxy<T> constructionProxy, SingleParameterInjector<?>[] parameterInjectors, MembersInjectorImpl<T> membersInjector) throws ErrorsException {
        this.injectableMembers = injectableMembers;
        this.constructionProxy = constructionProxy;
        this.parameterInjectors = parameterInjectors;
        this.membersInjector = membersInjector;
    }

    public ImmutableSet<InjectionPoint> getInjectableMembers() {
        return this.injectableMembers;
    }

    ConstructionProxy<T> getConstructionProxy() {
        return this.constructionProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object construct(Errors errors, InternalContext context, Class<?> expectedType) throws ErrorsException {
        ConstructionContext constructionContext = context.getConstructionContext(this);
        if (constructionContext.isConstructing()) {
            return constructionContext.createProxy(errors, expectedType);
        }
        Object t = constructionContext.getCurrentReference();
        if (t != null) {
            return t;
        }
        try {
            Object parameters2;
            constructionContext.startConstruction();
            try {
                parameters2 = SingleParameterInjector.getAll(errors, context, this.parameterInjectors);
                t = this.constructionProxy.newInstance(parameters2);
                constructionContext.setProxyDelegates(t);
            }
            finally {
                constructionContext.finishConstruction();
            }
            constructionContext.setCurrentReference(t);
            this.membersInjector.injectMembers(t, errors, context);
            this.membersInjector.notifyListeners(t, errors);
            parameters2 = t;
            return parameters2;
        }
        catch (InvocationTargetException userException) {
            Throwable cause2 = userException.getCause() != null ? userException.getCause() : userException;
            throw errors.withSource(this.constructionProxy.getInjectionPoint()).errorInjectingConstructor(cause2).toException();
        }
        finally {
            constructionContext.removeCurrentReference();
        }
    }
}

