/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import java.util.List;
import java.util.Map;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Iterables;
import org.elasticsearch.common.inject.Binding;
import org.elasticsearch.common.inject.BindingProcessor;
import org.elasticsearch.common.inject.ContextualCallable;
import org.elasticsearch.common.inject.DeferredLookups;
import org.elasticsearch.common.inject.Initializer;
import org.elasticsearch.common.inject.InjectionRequestProcessor;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.InjectorImpl;
import org.elasticsearch.common.inject.InjectorShell;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.LookupProcessor;
import org.elasticsearch.common.inject.MembersInjector;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.Stage;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.internal.BindingImpl;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.internal.ErrorsException;
import org.elasticsearch.common.inject.internal.InternalContext;
import org.elasticsearch.common.inject.internal.Stopwatch;
import org.elasticsearch.common.inject.spi.Dependency;

class InjectorBuilder {
    private final Stopwatch stopwatch = new Stopwatch();
    private final Errors errors = new Errors();
    private Stage stage;
    private final Initializer initializer = new Initializer();
    private final BindingProcessor bindingProcesor;
    private final InjectionRequestProcessor injectionRequestProcessor;
    private final InjectorShell.Builder shellBuilder = new InjectorShell.Builder();
    private List<InjectorShell> shells;

    InjectorBuilder() {
        this.injectionRequestProcessor = new InjectionRequestProcessor(this.errors, this.initializer);
        this.bindingProcesor = new BindingProcessor(this.errors, this.initializer);
    }

    InjectorBuilder stage(Stage stage) {
        this.shellBuilder.stage(stage);
        this.stage = stage;
        return this;
    }

    InjectorBuilder parentInjector(InjectorImpl parent) {
        this.shellBuilder.parent(parent);
        return this.stage(parent.getInstance(Stage.class));
    }

    InjectorBuilder addModules(Iterable<? extends Module> modules) {
        this.shellBuilder.addModules(modules);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Injector build() {
        if (this.shellBuilder == null) {
            throw new AssertionError((Object)"Already built, builders are not reusable.");
        }
        Object object = this.shellBuilder.lock();
        synchronized (object) {
            this.shells = this.shellBuilder.build(this.initializer, this.bindingProcesor, this.stopwatch, this.errors);
            this.stopwatch.resetAndLog("Injector construction");
            this.initializeStatically();
        }
        if (this.stage == Stage.TOOL) {
            return new ToolStageInjector(this.primaryInjector());
        }
        this.injectDynamically();
        return this.primaryInjector();
    }

    private void initializeStatically() {
        this.bindingProcesor.initializeBindings();
        this.stopwatch.resetAndLog("Binding initialization");
        for (InjectorShell shell : this.shells) {
            shell.getInjector().index();
        }
        this.stopwatch.resetAndLog("Binding indexing");
        this.injectionRequestProcessor.process(this.shells);
        this.stopwatch.resetAndLog("Collecting injection requests");
        this.bindingProcesor.runCreationListeners();
        this.stopwatch.resetAndLog("Binding validation");
        this.injectionRequestProcessor.validate();
        this.stopwatch.resetAndLog("Static validation");
        this.initializer.validateOustandingInjections(this.errors);
        this.stopwatch.resetAndLog("Instance member validation");
        new LookupProcessor(this.errors).process(this.shells);
        for (InjectorShell shell : this.shells) {
            ((DeferredLookups)shell.getInjector().lookups).initialize(this.errors);
        }
        this.stopwatch.resetAndLog("Provider verification");
        for (InjectorShell shell : this.shells) {
            if (!shell.getElements().isEmpty()) {
                throw new AssertionError((Object)("Failed to execute " + shell.getElements()));
            }
        }
        this.errors.throwCreationExceptionIfErrorsExist();
    }

    private Injector primaryInjector() {
        return this.shells.get(0).getInjector();
    }

    private void injectDynamically() {
        this.injectionRequestProcessor.injectMembers();
        this.stopwatch.resetAndLog("Static member injection");
        this.initializer.injectAll(this.errors);
        this.stopwatch.resetAndLog("Instance injection");
        this.errors.throwCreationExceptionIfErrorsExist();
        for (InjectorShell shell : this.shells) {
            this.loadEagerSingletons(shell.getInjector(), this.stage, this.errors);
        }
        this.stopwatch.resetAndLog("Preloading singletons");
        this.errors.throwCreationExceptionIfErrorsExist();
    }

    public void loadEagerSingletons(InjectorImpl injector, Stage stage, final Errors errors) {
        ImmutableSet<BindingImpl<?>> candidateBindings = ImmutableSet.copyOf(Iterables.concat(injector.state.getExplicitBindingsThisLevel().values(), injector.jitBindings.values()));
        for (final BindingImpl bindingImpl : candidateBindings) {
            if (!bindingImpl.getScoping().isEagerSingleton(stage)) continue;
            try {
                injector.callInContext(new ContextualCallable<Void>(){
                    Dependency<?> dependency;
                    {
                        this.dependency = Dependency.get(bindingImpl.getKey());
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void call(InternalContext context) {
                        context.setDependency(this.dependency);
                        Errors errorsForBinding = errors.withSource(this.dependency);
                        try {
                            bindingImpl.getInternalFactory().get(errorsForBinding, context, this.dependency);
                        }
                        catch (ErrorsException e) {
                            errorsForBinding.merge(e.getErrors());
                        }
                        finally {
                            context.setDependency(null);
                        }
                        return null;
                    }
                });
            }
            catch (ErrorsException e) {
                throw new AssertionError();
            }
        }
    }

    static class ToolStageInjector
    implements Injector {
        private final Injector delegateInjector;

        ToolStageInjector(Injector delegateInjector) {
            this.delegateInjector = delegateInjector;
        }

        @Override
        public void injectMembers(Object o) {
            throw new UnsupportedOperationException("Injector.injectMembers(Object) is not supported in Stage.TOOL");
        }

        @Override
        public Map<Key<?>, Binding<?>> getBindings() {
            return this.delegateInjector.getBindings();
        }

        @Override
        public <T> Binding<T> getBinding(Key<T> key2) {
            return this.delegateInjector.getBinding(key2);
        }

        @Override
        public <T> Binding<T> getBinding(Class<T> type2) {
            return this.delegateInjector.getBinding(type2);
        }

        @Override
        public <T> List<Binding<T>> findBindingsByType(TypeLiteral<T> type2) {
            return this.delegateInjector.findBindingsByType(type2);
        }

        @Override
        public Injector getParent() {
            return this.delegateInjector.getParent();
        }

        @Override
        public Injector createChildInjector(Iterable<? extends Module> modules) {
            return this.delegateInjector.createChildInjector(modules);
        }

        @Override
        public Injector createChildInjector(Module ... modules) {
            return this.delegateInjector.createChildInjector(modules);
        }

        @Override
        public <T> Provider<T> getProvider(Key<T> key2) {
            throw new UnsupportedOperationException("Injector.getProvider(Key<T>) is not supported in Stage.TOOL");
        }

        @Override
        public <T> Provider<T> getProvider(Class<T> type2) {
            throw new UnsupportedOperationException("Injector.getProvider(Class<T>) is not supported in Stage.TOOL");
        }

        @Override
        public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> typeLiteral) {
            throw new UnsupportedOperationException("Injector.getMembersInjector(TypeLiteral<T>) is not supported in Stage.TOOL");
        }

        @Override
        public <T> MembersInjector<T> getMembersInjector(Class<T> type2) {
            throw new UnsupportedOperationException("Injector.getMembersInjector(Class<T>) is not supported in Stage.TOOL");
        }

        @Override
        public <T> T getInstance(Key<T> key2) {
            throw new UnsupportedOperationException("Injector.getInstance(Key<T>) is not supported in Stage.TOOL");
        }

        @Override
        public <T> T getInstance(Class<T> type2) {
            throw new UnsupportedOperationException("Injector.getInstance(Class<T>) is not supported in Stage.TOOL");
        }
    }
}

