/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.inject.Binding;
import org.elasticsearch.common.inject.CreationException;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.InjectorImpl;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.matcher.Matcher;
import org.elasticsearch.common.inject.name.Names;
import org.elasticsearch.common.inject.spi.Message;

public class Injectors {
    public static Throwable getFirstErrorFailure(CreationException e) {
        if (e.getErrorMessages().isEmpty()) {
            return e;
        }
        for (Message message2 : e.getErrorMessages()) {
            if (message2.getCause() == null) continue;
            return message2.getCause();
        }
        return e;
    }

    public static <T> T getInstance(Injector injector, Class<T> type2, String name2) {
        return injector.getInstance(Key.get(type2, (Annotation)Names.named(name2)));
    }

    public static <T> Set<T> getInstancesOf(Injector injector, Class<T> baseClass) {
        HashSet<T> answer = Sets.newHashSet();
        Set<Map.Entry<Key<?>, Binding<?>>> entries2 = injector.getBindings().entrySet();
        for (Map.Entry<Key<?>, Binding<?>> entry : entries2) {
            Binding<?> binding2;
            Object value2;
            Key<?> key2 = entry.getKey();
            Class<?> keyType = Injectors.getKeyType(key2);
            if (keyType == null || !baseClass.isAssignableFrom(keyType) || (value2 = (binding2 = entry.getValue()).getProvider().get()) == null) continue;
            T castValue = baseClass.cast(value2);
            answer.add(castValue);
        }
        return answer;
    }

    public static <T> Set<T> getInstancesOf(Injector injector, Matcher<Class> matcher) {
        HashSet<?> answer = Sets.newHashSet();
        Set<Map.Entry<Key<?>, Binding<?>>> entries2 = injector.getBindings().entrySet();
        for (Map.Entry<Key<?>, Binding<?>> entry : entries2) {
            Key<?> key2 = entry.getKey();
            Class<?> keyType = Injectors.getKeyType(key2);
            if (keyType == null || !matcher.matches(keyType)) continue;
            Binding<?> binding2 = entry.getValue();
            Object value2 = binding2.getProvider().get();
            answer.add(value2);
        }
        return answer;
    }

    public static <T> Set<Provider<T>> getProvidersOf(Injector injector, Matcher<Class> matcher) {
        HashSet<Provider<T>> answer = Sets.newHashSet();
        Set<Map.Entry<Key<?>, Binding<?>>> entries2 = injector.getBindings().entrySet();
        for (Map.Entry<Key<?>, Binding<?>> entry : entries2) {
            Key<?> key2 = entry.getKey();
            Class<?> keyType = Injectors.getKeyType(key2);
            if (keyType == null || !matcher.matches(keyType)) continue;
            Binding<?> binding2 = entry.getValue();
            answer.add(binding2.getProvider());
        }
        return answer;
    }

    public static <T> Set<Provider<T>> getProvidersOf(Injector injector, Class<T> baseClass) {
        HashSet<Provider<T>> answer = Sets.newHashSet();
        Set<Map.Entry<Key<?>, Binding<?>>> entries2 = injector.getBindings().entrySet();
        for (Map.Entry<Key<?>, Binding<?>> entry : entries2) {
            Key<?> key2 = entry.getKey();
            Class<?> keyType = Injectors.getKeyType(key2);
            if (keyType == null || !baseClass.isAssignableFrom(keyType)) continue;
            Binding<?> binding2 = entry.getValue();
            answer.add(binding2.getProvider());
        }
        return answer;
    }

    public static boolean hasBinding(Injector injector, Matcher<Class> matcher) {
        return !Injectors.getBindingsOf(injector, matcher).isEmpty();
    }

    public static boolean hasBinding(Injector injector, Class<?> baseClass) {
        return !Injectors.getBindingsOf(injector, baseClass).isEmpty();
    }

    public static boolean hasBinding(Injector injector, Key<?> key2) {
        Binding<?> binding2 = Injectors.getBinding(injector, key2);
        return binding2 != null;
    }

    public static Binding<?> getBinding(Injector injector, Key<?> key2) {
        Map<Key<?>, Binding<?>> bindings = injector.getBindings();
        Binding<?> binding2 = bindings.get(key2);
        return binding2;
    }

    public static Set<Binding<?>> getBindingsOf(Injector injector, Matcher<Class> matcher) {
        HashSet<Binding<?>> answer = Sets.newHashSet();
        Set<Map.Entry<Key<?>, Binding<?>>> entries2 = injector.getBindings().entrySet();
        for (Map.Entry<Key<?>, Binding<?>> entry : entries2) {
            Key<?> key2 = entry.getKey();
            Class<?> keyType = Injectors.getKeyType(key2);
            if (keyType == null || !matcher.matches(keyType)) continue;
            answer.add(entry.getValue());
        }
        return answer;
    }

    public static Set<Binding<?>> getBindingsOf(Injector injector, Class<?> baseClass) {
        HashSet<Binding<?>> answer = Sets.newHashSet();
        Set<Map.Entry<Key<?>, Binding<?>>> entries2 = injector.getBindings().entrySet();
        for (Map.Entry<Key<?>, Binding<?>> entry : entries2) {
            Key<?> key2 = entry.getKey();
            Class<?> keyType = Injectors.getKeyType(key2);
            if (keyType == null || !baseClass.isAssignableFrom(keyType)) continue;
            answer.add(entry.getValue());
        }
        return answer;
    }

    public static <T> Class<?> getKeyType(Key<?> key2) {
        Class keyType = null;
        TypeLiteral<?> typeLiteral = key2.getTypeLiteral();
        Type type2 = typeLiteral.getType();
        if (type2 instanceof Class) {
            keyType = (Class)type2;
        }
        return keyType;
    }

    public static void close(Injector injector) {
    }

    public static void cleanCaches(Injector injector) {
        ((InjectorImpl)injector).clearCache();
        if (injector.getParent() != null) {
            Injectors.cleanCaches(injector.getParent());
        }
    }
}

