/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import java.lang.reflect.Constructor;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.PreProcessModule;
import org.elasticsearch.common.settings.Settings;

public class Modules {
    public static Module createModule(String moduleClass, Settings settings) throws ClassNotFoundException {
        return Modules.createModule(settings.getClassLoader().loadClass(moduleClass), settings);
    }

    public static Module createModule(Class<? extends Module> moduleClass, @Nullable Settings settings) {
        try {
            Constructor<? extends Module> constructor2 = moduleClass.getConstructor(Settings.class);
            try {
                return constructor2.newInstance(settings);
            }
            catch (Exception e) {
                throw new ElasticSearchException("Failed to create module [" + moduleClass + "]", e);
            }
        }
        catch (NoSuchMethodException e) {
            try {
                Constructor<? extends Module> constructor2 = moduleClass.getConstructor(new Class[0]);
                try {
                    return constructor2.newInstance(new Object[0]);
                }
                catch (Exception e1) {
                    throw new ElasticSearchException("Failed to create module [" + moduleClass + "]", e);
                }
            }
            catch (NoSuchMethodException e1) {
                throw new ElasticSearchException("No constructor for [" + moduleClass + "]");
            }
        }
    }

    public static void processModules(Iterable<Module> modules) {
        for (Module module : modules) {
            if (!(module instanceof PreProcessModule)) continue;
            for (Module module1 : modules) {
                ((PreProcessModule)((Object)module)).processModule(module1);
            }
        }
    }
}

