/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.elasticsearch.common.inject.InjectorImpl;
import org.elasticsearch.common.inject.SingleMemberInjector;
import org.elasticsearch.common.inject.SingleParameterInjector;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.internal.ErrorsException;
import org.elasticsearch.common.inject.internal.InternalContext;
import org.elasticsearch.common.inject.spi.InjectionPoint;

class SingleMethodInjector
implements SingleMemberInjector {
    final InjectorImpl.MethodInvoker methodInvoker;
    final SingleParameterInjector<?>[] parameterInjectors;
    final InjectionPoint injectionPoint;

    public SingleMethodInjector(InjectorImpl injector, InjectionPoint injectionPoint, Errors errors) throws ErrorsException {
        this.injectionPoint = injectionPoint;
        Method method2 = (Method)injectionPoint.getMember();
        this.methodInvoker = this.createMethodInvoker(method2);
        this.parameterInjectors = injector.getParametersInjectors(injectionPoint.getDependencies(), errors);
    }

    private InjectorImpl.MethodInvoker createMethodInvoker(final Method method2) {
        int modifiers2 = method2.getModifiers();
        if (Modifier.isPrivate(modifiers2) || !Modifier.isProtected(modifiers2)) {
            // empty if block
        }
        if (!Modifier.isPublic(modifiers2)) {
            method2.setAccessible(true);
        }
        return new InjectorImpl.MethodInvoker(){

            @Override
            public Object invoke(Object target, Object ... parameters2) throws IllegalAccessException, InvocationTargetException {
                return method2.invoke(target, parameters2);
            }
        };
    }

    @Override
    public InjectionPoint getInjectionPoint() {
        return this.injectionPoint;
    }

    @Override
    public void inject(Errors errors, InternalContext context, Object o) {
        Object[] parameters2;
        try {
            parameters2 = SingleParameterInjector.getAll(errors, context, this.parameterInjectors);
        }
        catch (ErrorsException e) {
            errors.merge(e.getErrors());
            return;
        }
        try {
            this.methodInvoker.invoke(o, parameters2);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException userException) {
            Throwable cause2 = userException.getCause() != null ? userException.getCause() : userException;
            errors.withSource(this.injectionPoint).errorInjectingMethod(cause2);
        }
    }
}

