/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject.assistedinject;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Iterables;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Binding;
import org.elasticsearch.common.inject.ConfigurationException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.ProvisionException;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.inject.internal.Annotations;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.internal.ErrorsException;
import org.elasticsearch.common.inject.spi.Message;
import org.elasticsearch.common.inject.util.Providers;

final class FactoryProvider2<F>
implements InvocationHandler,
Provider<F> {
    static final Assisted DEFAULT_ANNOTATION = new Assisted(){

        @Override
        public String value() {
            return "";
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Assisted.class;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Assisted && ((Assisted)o).value().equals("");
        }

        @Override
        public int hashCode() {
            return 127 * "value".hashCode() ^ "".hashCode();
        }

        @Override
        public String toString() {
            return "@" + Assisted.class.getName() + "(value=)";
        }
    };
    private final Key<?> producedType;
    private final ImmutableMap<Method, Key<?>> returnTypesByMethod;
    private final ImmutableMap<Method, ImmutableList<Key<?>>> paramTypes;
    private Injector injector;
    private final F factory;

    FactoryProvider2(TypeLiteral<F> factoryType, Key<?> producedType) {
        this.producedType = producedType;
        Errors errors = new Errors();
        Class<F> factoryRawType = factoryType.getRawType();
        try {
            ImmutableMap.Builder<Method, Key<?>> returnTypesBuilder = ImmutableMap.builder();
            ImmutableMap.Builder paramTypesBuilder = ImmutableMap.builder();
            for (Method method2 : factoryRawType.getMethods()) {
                Key<?> returnType = Annotations.getKey(factoryType.getReturnType(method2), method2, method2.getAnnotations(), errors);
                returnTypesBuilder.put(method2, returnType);
                List<TypeLiteral<?>> params2 = factoryType.getParameterTypes(method2);
                Annotation[][] paramAnnotations = method2.getParameterAnnotations();
                int p2 = 0;
                ArrayList<Key<?>> keys2 = Lists.newArrayList();
                for (TypeLiteral<?> param : params2) {
                    Key<?> paramKey = Annotations.getKey(param, method2, paramAnnotations[p2++], errors);
                    keys2.add(this.assistKey(method2, paramKey, errors));
                }
                paramTypesBuilder.put(method2, ImmutableList.copyOf(keys2));
            }
            this.returnTypesByMethod = returnTypesBuilder.build();
            this.paramTypes = paramTypesBuilder.build();
        }
        catch (ErrorsException e) {
            throw new ConfigurationException(e.getErrors().getMessages());
        }
        this.factory = factoryRawType.cast(Proxy.newProxyInstance(factoryRawType.getClassLoader(), new Class[]{factoryRawType}, (InvocationHandler)this));
    }

    @Override
    public F get() {
        return this.factory;
    }

    private <T> Key<T> assistKey(Method method2, Key<T> key2, Errors errors) throws ErrorsException {
        if (key2.getAnnotationType() == null) {
            return Key.get(key2.getTypeLiteral(), (Annotation)DEFAULT_ANNOTATION);
        }
        if (key2.getAnnotationType() == Assisted.class) {
            return key2;
        }
        errors.withSource(method2).addMessage("Only @Assisted is allowed for factory parameters, but found @%s", key2.getAnnotationType());
        throw errors.toException();
    }

    @Inject
    void initialize(Injector injector) {
        if (this.injector != null) {
            throw new ConfigurationException(ImmutableList.of(new Message(FactoryProvider2.class, "Factories.create() factories may only be used in one Injector!")));
        }
        this.injector = injector;
        for (Method method2 : this.returnTypesByMethod.keySet()) {
            Object[] args2 = new Object[method2.getParameterTypes().length];
            Arrays.fill(args2, "dummy object for validating Factories");
            this.getBindingFromNewInjector(method2, args2);
        }
    }

    public Binding<?> getBindingFromNewInjector(final Method method2, final Object[] args2) {
        Preconditions.checkState(this.injector != null, "Factories.create() factories cannot be used until they're initialized by Guice.");
        final Key<?> returnType = this.returnTypesByMethod.get(method2);
        AbstractModule assistedModule = new AbstractModule(){

            @Override
            protected void configure() {
                Binder binder = this.binder().withSource(method2);
                int p2 = 0;
                for (Key paramKey : (ImmutableList)FactoryProvider2.this.paramTypes.get(method2)) {
                    binder.bind(paramKey).toProvider(Providers.of(args2[p2++]));
                }
                if (FactoryProvider2.this.producedType != null && !returnType.equals(FactoryProvider2.this.producedType)) {
                    binder.bind(returnType).to(FactoryProvider2.this.producedType);
                } else {
                    binder.bind(returnType);
                }
            }
        };
        Injector forCreate = this.injector.createChildInjector(assistedModule);
        return forCreate.getBinding(returnType);
    }

    @Override
    public Object invoke(Object proxy2, Method method2, Object[] args2) throws Throwable {
        if (method2.getDeclaringClass() == Object.class) {
            return method2.invoke((Object)this, args2);
        }
        Provider<?> provider = this.getBindingFromNewInjector(method2, args2).getProvider();
        try {
            return provider.get();
        }
        catch (ProvisionException e) {
            Message onlyError;
            Throwable cause2;
            if (e.getErrorMessages().size() == 1 && (cause2 = (onlyError = Iterables.getOnlyElement(e.getErrorMessages())).getCause()) != null && FactoryProvider2.canRethrow(method2, cause2)) {
                throw cause2;
            }
            throw e;
        }
    }

    public String toString() {
        return this.factory.getClass().getInterfaces()[0].getName() + " for " + this.producedType.getTypeLiteral();
    }

    public boolean equals(Object o) {
        return o == this || o == this.factory;
    }

    static boolean canRethrow(Method invoked, Throwable thrown) {
        if (thrown instanceof Error || thrown instanceof RuntimeException) {
            return true;
        }
        for (Class<?> declared : invoked.getExceptionTypes()) {
            if (!declared.isInstance(thrown)) continue;
            return true;
        }
        return false;
    }
}

