/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject.internal;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Member;
import org.elasticsearch.common.inject.BindingAnnotation;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.ScopeAnnotation;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.internal.Classes;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.internal.ErrorsException;

public class Annotations {
    public static boolean isRetainedAtRuntime(Class<? extends Annotation> annotationType) {
        Retention retention = annotationType.getAnnotation(Retention.class);
        return retention != null && retention.value() == RetentionPolicy.RUNTIME;
    }

    public static Class<? extends Annotation> findScopeAnnotation(Errors errors, Class<?> implementation) {
        return Annotations.findScopeAnnotation(errors, implementation.getAnnotations());
    }

    public static Class<? extends Annotation> findScopeAnnotation(Errors errors, Annotation[] annotations2) {
        Class<? extends Annotation> found = null;
        for (Annotation annotation2 : annotations2) {
            if (!annotation2.annotationType().isAnnotationPresent(ScopeAnnotation.class)) continue;
            if (found != null) {
                errors.duplicateScopeAnnotations(found, annotation2.annotationType());
                continue;
            }
            found = annotation2.annotationType();
        }
        return found;
    }

    public static boolean isScopeAnnotation(Class<? extends Annotation> annotationType) {
        return annotationType.isAnnotationPresent(ScopeAnnotation.class);
    }

    public static void checkForMisplacedScopeAnnotations(Class<?> type2, Object source2, Errors errors) {
        if (Classes.isConcrete(type2)) {
            return;
        }
        Class<? extends Annotation> scopeAnnotation = Annotations.findScopeAnnotation(errors, type2);
        if (scopeAnnotation != null) {
            errors.withSource(type2).scopeAnnotationOnAbstractType(scopeAnnotation, type2, source2);
        }
    }

    public static Key<?> getKey(TypeLiteral<?> type2, Member member, Annotation[] annotations2, Errors errors) throws ErrorsException {
        int numErrorsBefore = errors.size();
        Annotation found = Annotations.findBindingAnnotation(errors, member, annotations2);
        errors.throwIfNewErrors(numErrorsBefore);
        return found == null ? Key.get(type2) : Key.get(type2, found);
    }

    public static Annotation findBindingAnnotation(Errors errors, Member member, Annotation[] annotations2) {
        Annotation found = null;
        for (Annotation annotation2 : annotations2) {
            if (!annotation2.annotationType().isAnnotationPresent(BindingAnnotation.class)) continue;
            if (found != null) {
                errors.duplicateBindingAnnotations(member, found.annotationType(), annotation2.annotationType());
                continue;
            }
            found = annotation2;
        }
        return found;
    }
}

