/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject.internal;

import java.lang.annotation.Annotation;
import java.util.List;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.binder.AnnotatedConstantBindingBuilder;
import org.elasticsearch.common.inject.binder.ConstantBindingBuilder;
import org.elasticsearch.common.inject.internal.AbstractBindingBuilder;
import org.elasticsearch.common.inject.internal.BindingImpl;
import org.elasticsearch.common.inject.internal.InstanceBindingImpl;
import org.elasticsearch.common.inject.spi.Element;
import org.elasticsearch.common.inject.spi.InjectionPoint;

public final class ConstantBindingBuilderImpl<T>
extends AbstractBindingBuilder<T>
implements AnnotatedConstantBindingBuilder,
ConstantBindingBuilder {
    public ConstantBindingBuilderImpl(Binder binder, List<Element> elements, Object source2) {
        super(binder, elements, source2, NULL_KEY);
    }

    @Override
    public ConstantBindingBuilder annotatedWith(Class<? extends Annotation> annotationType) {
        this.annotatedWithInternal(annotationType);
        return this;
    }

    @Override
    public ConstantBindingBuilder annotatedWith(Annotation annotation2) {
        this.annotatedWithInternal(annotation2);
        return this;
    }

    @Override
    public void to(String value2) {
        this.toConstant(String.class, value2);
    }

    @Override
    public void to(int value2) {
        this.toConstant(Integer.class, value2);
    }

    @Override
    public void to(long value2) {
        this.toConstant(Long.class, value2);
    }

    @Override
    public void to(boolean value2) {
        this.toConstant(Boolean.class, value2);
    }

    @Override
    public void to(double value2) {
        this.toConstant(Double.class, value2);
    }

    @Override
    public void to(float value2) {
        this.toConstant(Float.class, Float.valueOf(value2));
    }

    @Override
    public void to(short value2) {
        this.toConstant(Short.class, value2);
    }

    @Override
    public void to(char value2) {
        this.toConstant(Character.class, Character.valueOf(value2));
    }

    @Override
    public void to(Class<?> value2) {
        this.toConstant(Class.class, value2);
    }

    @Override
    public <E extends Enum<E>> void to(E value2) {
        this.toConstant(value2.getDeclaringClass(), value2);
    }

    private void toConstant(Class<?> type2, Object instance) {
        Class<?> typeAsClassT = type2;
        Object instanceAsT = instance;
        if (this.keyTypeIsSet()) {
            this.binder.addError("Constant value is set more than once.", new Object[0]);
            return;
        }
        BindingImpl base = this.getBinding();
        Key<?> key2 = base.getKey().getAnnotation() != null ? Key.get(typeAsClassT, base.getKey().getAnnotation()) : (base.getKey().getAnnotationType() != null ? Key.get(typeAsClassT, base.getKey().getAnnotationType()) : Key.get(typeAsClassT));
        if (instanceAsT == null) {
            this.binder.addError("Binding to null instances is not allowed. Use toProvider(Providers.of(null)) if this is your intended behaviour.", new Object[0]);
        }
        this.setBinding(new InstanceBindingImpl<Object>(base.getSource(), key2, base.getScoping(), ImmutableSet.<InjectionPoint>of(), instanceAsT));
    }

    public String toString() {
        return "ConstantBindingBuilder";
    }
}

