/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject.internal;

import java.util.Map;
import org.elasticsearch.common.base.Function;
import org.elasticsearch.common.collect.MapMaker;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.internal.ErrorsException;
import org.elasticsearch.common.inject.internal.Nullable;

public abstract class FailableCache<K, V> {
    private final Map<K, Object> delegate = new MapMaker().makeComputingMap(new Function<K, Object>(){

        @Override
        public Object apply(@Nullable K key2) {
            Errors errors = new Errors();
            Object result2 = null;
            try {
                result2 = FailableCache.this.create(key2, errors);
            }
            catch (ErrorsException e) {
                errors.merge(e.getErrors());
            }
            return errors.hasErrors() ? errors : result2;
        }
    });

    protected abstract V create(K var1, Errors var2) throws ErrorsException;

    public V get(K key2, Errors errors) throws ErrorsException {
        Object resultOrError = this.delegate.get(key2);
        if (resultOrError instanceof Errors) {
            errors.merge((Errors)resultOrError);
            throw errors.toException();
        }
        Object result2 = resultOrError;
        return (V)result2;
    }
}

