/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject.multibindings;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.binder.LinkedBindingBuilder;
import org.elasticsearch.common.inject.multibindings.Multibinder;
import org.elasticsearch.common.inject.multibindings.RealElement;
import org.elasticsearch.common.inject.spi.Dependency;
import org.elasticsearch.common.inject.spi.ProviderWithDependencies;
import org.elasticsearch.common.inject.util.Types;

public abstract class MapBinder<K, V> {
    private MapBinder() {
    }

    public static <K, V> MapBinder<K, V> newMapBinder(Binder binder, TypeLiteral<K> keyType, TypeLiteral<V> valueType) {
        binder = binder.skipSources(MapBinder.class, RealMapBinder.class);
        return MapBinder.newMapBinder(binder, valueType, Key.get(MapBinder.mapOf(keyType, valueType)), Key.get(MapBinder.mapOfProviderOf(keyType, valueType)), Multibinder.newSetBinder(binder, MapBinder.entryOfProviderOf(keyType, valueType)));
    }

    public static <K, V> MapBinder<K, V> newMapBinder(Binder binder, Class<K> keyType, Class<V> valueType) {
        return MapBinder.newMapBinder(binder, TypeLiteral.get(keyType), TypeLiteral.get(valueType));
    }

    public static <K, V> MapBinder<K, V> newMapBinder(Binder binder, TypeLiteral<K> keyType, TypeLiteral<V> valueType, Annotation annotation2) {
        binder = binder.skipSources(MapBinder.class, RealMapBinder.class);
        return MapBinder.newMapBinder(binder, valueType, Key.get(MapBinder.mapOf(keyType, valueType), annotation2), Key.get(MapBinder.mapOfProviderOf(keyType, valueType), annotation2), Multibinder.newSetBinder(binder, MapBinder.entryOfProviderOf(keyType, valueType), annotation2));
    }

    public static <K, V> MapBinder<K, V> newMapBinder(Binder binder, Class<K> keyType, Class<V> valueType, Annotation annotation2) {
        return MapBinder.newMapBinder(binder, TypeLiteral.get(keyType), TypeLiteral.get(valueType), annotation2);
    }

    public static <K, V> MapBinder<K, V> newMapBinder(Binder binder, TypeLiteral<K> keyType, TypeLiteral<V> valueType, Class<? extends Annotation> annotationType) {
        binder = binder.skipSources(MapBinder.class, RealMapBinder.class);
        return MapBinder.newMapBinder(binder, valueType, Key.get(MapBinder.mapOf(keyType, valueType), annotationType), Key.get(MapBinder.mapOfProviderOf(keyType, valueType), annotationType), Multibinder.newSetBinder(binder, MapBinder.entryOfProviderOf(keyType, valueType), annotationType));
    }

    public static <K, V> MapBinder<K, V> newMapBinder(Binder binder, Class<K> keyType, Class<V> valueType, Class<? extends Annotation> annotationType) {
        return MapBinder.newMapBinder(binder, TypeLiteral.get(keyType), TypeLiteral.get(valueType), annotationType);
    }

    private static <K, V> TypeLiteral<Map<K, V>> mapOf(TypeLiteral<K> keyType, TypeLiteral<V> valueType) {
        return TypeLiteral.get(Types.mapOf(keyType.getType(), valueType.getType()));
    }

    private static <K, V> TypeLiteral<Map<K, Provider<V>>> mapOfProviderOf(TypeLiteral<K> keyType, TypeLiteral<V> valueType) {
        return TypeLiteral.get(Types.mapOf(keyType.getType(), Types.newParameterizedType(Provider.class, new Type[]{valueType.getType()})));
    }

    private static <K, V> TypeLiteral<Map.Entry<K, Provider<V>>> entryOfProviderOf(TypeLiteral<K> keyType, TypeLiteral<V> valueType) {
        return TypeLiteral.get(Types.newParameterizedTypeWithOwner(Map.class, Map.Entry.class, new Type[]{keyType.getType(), Types.providerOf(valueType.getType())}));
    }

    private static <K, V> MapBinder<K, V> newMapBinder(Binder binder, TypeLiteral<V> valueType, Key<Map<K, V>> mapKey, Key<Map<K, Provider<V>>> providerMapKey, Multibinder<Map.Entry<K, Provider<V>>> entrySetBinder) {
        RealMapBinder mapBinder = new RealMapBinder(binder, valueType, mapKey, providerMapKey, entrySetBinder);
        binder.install(mapBinder);
        return mapBinder;
    }

    public abstract LinkedBindingBuilder<V> addBinding(K var1);

    private static final class RealMapBinder<K, V>
    extends MapBinder<K, V>
    implements Module {
        private final TypeLiteral<V> valueType;
        private final Key<Map<K, V>> mapKey;
        private final Key<Map<K, Provider<V>>> providerMapKey;
        private final Multibinder.RealMultibinder<Map.Entry<K, Provider<V>>> entrySetBinder;
        private Binder binder;

        private RealMapBinder(Binder binder, TypeLiteral<V> valueType, Key<Map<K, V>> mapKey, Key<Map<K, Provider<V>>> providerMapKey, Multibinder<Map.Entry<K, Provider<V>>> entrySetBinder) {
            this.valueType = valueType;
            this.mapKey = mapKey;
            this.providerMapKey = providerMapKey;
            this.entrySetBinder = (Multibinder.RealMultibinder)entrySetBinder;
            this.binder = binder;
        }

        @Override
        public LinkedBindingBuilder<V> addBinding(K key2) {
            Multibinder.checkNotNull(key2, "key");
            Multibinder.checkConfiguration(!this.isInitialized(), "MapBinder was already initialized", new Object[0]);
            Key<V> valueKey = Key.get(this.valueType, (Annotation)new RealElement(this.entrySetBinder.getSetName()));
            this.entrySetBinder.addBinding().toInstance(new MapEntry(key2, this.binder.getProvider(valueKey)));
            return this.binder.bind(valueKey);
        }

        @Override
        public void configure(Binder binder) {
            Multibinder.checkConfiguration(!this.isInitialized(), "MapBinder was already initialized", new Object[0]);
            final ImmutableSet<Dependency<Set<Map.Entry<K, Provider<V>>>>> dependencies = ImmutableSet.of(Dependency.get(this.entrySetBinder.getSetKey()));
            final Provider<Set<Map.Entry<K, Provider<V>>>> entrySetProvider = binder.getProvider(this.entrySetBinder.getSetKey());
            binder.bind(this.providerMapKey).toProvider(new ProviderWithDependencies<Map<K, Provider<V>>>(){
                private Map<K, Provider<V>> providerMap;

                @Inject
                void initialize() {
                    RealMapBinder.this.binder = null;
                    LinkedHashMap providerMapMutable = new LinkedHashMap();
                    for (Map.Entry entry : (Set)entrySetProvider.get()) {
                        Multibinder.checkConfiguration(providerMapMutable.put(entry.getKey(), entry.getValue()) == null, "Map injection failed due to duplicated key \"%s\"", entry.getKey());
                    }
                    this.providerMap = Collections.unmodifiableMap(providerMapMutable);
                }

                @Override
                public Map<K, Provider<V>> get() {
                    return this.providerMap;
                }

                @Override
                public Set<Dependency<?>> getDependencies() {
                    return dependencies;
                }
            });
            final Provider<Map<K, Provider<V>>> mapProvider = binder.getProvider(this.providerMapKey);
            binder.bind(this.mapKey).toProvider(new ProviderWithDependencies<Map<K, V>>(){

                @Override
                public Map<K, V> get() {
                    LinkedHashMap map = new LinkedHashMap();
                    for (Map.Entry entry : ((Map)mapProvider.get()).entrySet()) {
                        Object value2 = ((Provider)entry.getValue()).get();
                        Object key2 = entry.getKey();
                        Multibinder.checkConfiguration(value2 != null, "Map injection failed due to null value for key \"%s\"", key2);
                        map.put(key2, value2);
                    }
                    return Collections.unmodifiableMap(map);
                }

                @Override
                public Set<Dependency<?>> getDependencies() {
                    return dependencies;
                }
            });
        }

        private boolean isInitialized() {
            return this.binder == null;
        }

        public boolean equals(Object o) {
            return o instanceof RealMapBinder && ((RealMapBinder)o).mapKey.equals(this.mapKey);
        }

        public int hashCode() {
            return this.mapKey.hashCode();
        }

        private static final class MapEntry<K, V>
        implements Map.Entry<K, V> {
            private final K key;
            private final V value;

            private MapEntry(K key2, V value2) {
                this.key = key2;
                this.value = value2;
            }

            @Override
            public K getKey() {
                return this.key;
            }

            @Override
            public V getValue() {
                return this.value;
            }

            @Override
            public V setValue(V value2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean equals(Object obj) {
                return obj instanceof Map.Entry && this.key.equals(((Map.Entry)obj).getKey()) && this.value.equals(((Map.Entry)obj).getValue());
            }

            @Override
            public int hashCode() {
                return 127 * ("key".hashCode() ^ this.key.hashCode()) + 127 * ("value".hashCode() ^ this.value.hashCode());
            }

            public String toString() {
                return "MapEntry(" + this.key + ", " + this.value + ")";
            }
        }
    }
}

