/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.ConfigurationException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.internal.Annotations;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.internal.ErrorsException;
import org.elasticsearch.common.inject.internal.MoreTypes;
import org.elasticsearch.common.inject.internal.Nullability;
import org.elasticsearch.common.inject.spi.Dependency;

public final class InjectionPoint {
    private final boolean optional;
    private final Member member;
    private final ImmutableList<Dependency<?>> dependencies;

    private InjectionPoint(Member member, ImmutableList<Dependency<?>> dependencies, boolean optional) {
        this.member = member;
        this.dependencies = dependencies;
        this.optional = optional;
    }

    InjectionPoint(TypeLiteral<?> type2, Method method2) {
        this.member = method2;
        Inject inject2 = method2.getAnnotation(Inject.class);
        this.optional = inject2.optional();
        this.dependencies = this.forMember(method2, type2, method2.getParameterAnnotations());
    }

    InjectionPoint(TypeLiteral<?> type2, Constructor<?> constructor2) {
        this.member = constructor2;
        this.optional = false;
        this.dependencies = this.forMember(constructor2, type2, constructor2.getParameterAnnotations());
    }

    InjectionPoint(TypeLiteral<?> type2, Field field2) {
        this.member = field2;
        Inject inject2 = field2.getAnnotation(Inject.class);
        this.optional = inject2.optional();
        Annotation[] annotations2 = field2.getAnnotations();
        Errors errors = new Errors(field2);
        Key<?> key2 = null;
        try {
            key2 = Annotations.getKey(type2.getFieldType(field2), field2, annotations2, errors);
        }
        catch (ErrorsException e) {
            errors.merge(e.getErrors());
        }
        errors.throwConfigurationExceptionIfErrorsExist();
        this.dependencies = ImmutableList.of(this.newDependency(key2, Nullability.allowsNull(annotations2), -1));
    }

    private ImmutableList<Dependency<?>> forMember(Member member, TypeLiteral<?> type2, Annotation[][] paramterAnnotations) {
        Errors errors = new Errors(member);
        Iterator annotationsIterator = Arrays.asList(paramterAnnotations).iterator();
        ArrayList<Dependency<?>> dependencies = Lists.newArrayList();
        int index2 = 0;
        for (TypeLiteral<?> parameterType : type2.getParameterTypes(member)) {
            try {
                Annotation[] parameterAnnotations = (Annotation[])annotationsIterator.next();
                Key<?> key2 = Annotations.getKey(parameterType, member, parameterAnnotations, errors);
                dependencies.add(this.newDependency(key2, Nullability.allowsNull(parameterAnnotations), index2));
                ++index2;
            }
            catch (ErrorsException e) {
                errors.merge(e.getErrors());
            }
        }
        errors.throwConfigurationExceptionIfErrorsExist();
        return ImmutableList.copyOf(dependencies);
    }

    private <T> Dependency<T> newDependency(Key<T> key2, boolean allowsNull, int parameterIndex) {
        return new Dependency<T>(this, key2, allowsNull, parameterIndex);
    }

    public Member getMember() {
        return this.member;
    }

    public List<Dependency<?>> getDependencies() {
        return this.dependencies;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean equals(Object o) {
        return o instanceof InjectionPoint && this.member.equals(((InjectionPoint)o).member);
    }

    public int hashCode() {
        return this.member.hashCode();
    }

    public String toString() {
        return MoreTypes.toString(this.member);
    }

    public static InjectionPoint forConstructorOf(TypeLiteral<?> type2) {
        Class<?> rawType = MoreTypes.getRawType(type2.getType());
        Errors errors = new Errors(rawType);
        Constructor<?> injectableConstructor = null;
        for (Constructor<?> constructor2 : rawType.getDeclaredConstructors()) {
            Inject inject2 = constructor2.getAnnotation(Inject.class);
            if (inject2 == null) continue;
            if (inject2.optional()) {
                errors.optionalConstructor(constructor2);
            }
            if (injectableConstructor != null) {
                errors.tooManyConstructors(rawType);
            }
            injectableConstructor = constructor2;
            InjectionPoint.checkForMisplacedBindingAnnotations(injectableConstructor, errors);
        }
        errors.throwConfigurationExceptionIfErrorsExist();
        if (injectableConstructor != null) {
            return new InjectionPoint(type2, injectableConstructor);
        }
        try {
            Constructor<?> noArgConstructor = rawType.getDeclaredConstructor(new Class[0]);
            if (Modifier.isPrivate(noArgConstructor.getModifiers()) && !Modifier.isPrivate(rawType.getModifiers())) {
                errors.missingConstructor(rawType);
                throw new ConfigurationException(errors.getMessages());
            }
            InjectionPoint.checkForMisplacedBindingAnnotations(noArgConstructor, errors);
            return new InjectionPoint(type2, noArgConstructor);
        }
        catch (NoSuchMethodException e) {
            errors.missingConstructor(rawType);
            throw new ConfigurationException(errors.getMessages());
        }
    }

    public static InjectionPoint forConstructorOf(Class<?> type2) {
        return InjectionPoint.forConstructorOf(TypeLiteral.get(type2));
    }

    public static Set<InjectionPoint> forStaticMethodsAndFields(TypeLiteral type2) {
        ArrayList<InjectionPoint> sink = Lists.newArrayList();
        Errors errors = new Errors();
        InjectionPoint.addInjectionPoints(type2, Factory.FIELDS, true, sink, errors);
        InjectionPoint.addInjectionPoints(type2, Factory.METHODS, true, sink, errors);
        ImmutableSet<InjectionPoint> result2 = ImmutableSet.copyOf(sink);
        if (errors.hasErrors()) {
            throw new ConfigurationException(errors.getMessages()).withPartialValue(result2);
        }
        return result2;
    }

    public static Set<InjectionPoint> forStaticMethodsAndFields(Class<?> type2) {
        return InjectionPoint.forStaticMethodsAndFields(TypeLiteral.get(type2));
    }

    public static Set<InjectionPoint> forInstanceMethodsAndFields(TypeLiteral<?> type2) {
        ArrayList<InjectionPoint> sink = Lists.newArrayList();
        Errors errors = new Errors();
        InjectionPoint.addInjectionPoints(type2, Factory.FIELDS, false, sink, errors);
        InjectionPoint.addInjectionPoints(type2, Factory.METHODS, false, sink, errors);
        ImmutableSet<InjectionPoint> result2 = ImmutableSet.copyOf(sink);
        if (errors.hasErrors()) {
            throw new ConfigurationException(errors.getMessages()).withPartialValue(result2);
        }
        return result2;
    }

    public static Set<InjectionPoint> forInstanceMethodsAndFields(Class<?> type2) {
        return InjectionPoint.forInstanceMethodsAndFields(TypeLiteral.get(type2));
    }

    private static void checkForMisplacedBindingAnnotations(Member member, Errors errors) {
        Annotation misplacedBindingAnnotation = Annotations.findBindingAnnotation(errors, member, ((AnnotatedElement)((Object)member)).getAnnotations());
        if (misplacedBindingAnnotation == null) {
            return;
        }
        if (member instanceof Method) {
            try {
                if (member.getDeclaringClass().getDeclaredField(member.getName()) != null) {
                    return;
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        errors.misplacedBindingAnnotation(member, misplacedBindingAnnotation);
    }

    private static <M extends Member & AnnotatedElement> void addInjectionPoints(TypeLiteral<?> type2, Factory<M> factory, boolean statics, Collection<InjectionPoint> injectionPoints, Errors errors) {
        if (type2.getType() == Object.class) {
            return;
        }
        TypeLiteral<?> superType = type2.getSupertype(type2.getRawType().getSuperclass());
        InjectionPoint.addInjectionPoints(superType, factory, statics, injectionPoints, errors);
        InjectionPoint.addInjectorsForMembers(type2, factory, statics, injectionPoints, errors);
    }

    private static <M extends Member & AnnotatedElement> void addInjectorsForMembers(TypeLiteral<?> typeLiteral, Factory<M> factory, boolean statics, Collection<InjectionPoint> injectionPoints, Errors errors) {
        for (Member member : factory.getMembers(MoreTypes.getRawType(typeLiteral.getType()))) {
            Inject inject2;
            if (InjectionPoint.isStatic(member) != statics || (inject2 = ((AnnotatedElement)((Object)member)).getAnnotation(Inject.class)) == null) continue;
            try {
                injectionPoints.add(factory.create(typeLiteral, member, errors));
            }
            catch (ConfigurationException ignorable) {
                if (inject2.optional()) continue;
                errors.merge(ignorable.getErrorMessages());
            }
        }
    }

    private static boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    private static interface Factory<M extends Member & AnnotatedElement> {
        public static final Factory<Field> FIELDS = new Factory<Field>(){

            public Field[] getMembers(Class<?> type2) {
                return type2.getDeclaredFields();
            }

            @Override
            public InjectionPoint create(TypeLiteral<?> typeLiteral, Field member, Errors errors) {
                return new InjectionPoint(typeLiteral, member);
            }
        };
        public static final Factory<Method> METHODS = new Factory<Method>(){

            public Method[] getMembers(Class<?> type2) {
                return type2.getDeclaredMethods();
            }

            @Override
            public InjectionPoint create(TypeLiteral<?> typeLiteral, Method member, Errors errors) {
                InjectionPoint.checkForMisplacedBindingAnnotations(member, errors);
                return new InjectionPoint(typeLiteral, member);
            }
        };

        public M[] getMembers(Class<?> var1);

        public InjectionPoint create(TypeLiteral<?> var1, M var2, Errors var3);
    }
}

