/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.jackson.core.io;

public final class NumberInput {
    public static final String NASTY_SMALL_DOUBLE = "2.2250738585072012e-308";
    static final long L_BILLION = 1000000000L;
    static final String MIN_LONG_STR_NO_SIGN = String.valueOf(Long.MIN_VALUE).substring(1);
    static final String MAX_LONG_STR = String.valueOf(Long.MAX_VALUE);

    public static int parseInt(char[] digitChars, int offset2, int len) {
        int num = digitChars[offset2] - 48;
        if (++offset2 < (len += offset2)) {
            num = num * 10 + (digitChars[offset2] - 48);
            if (++offset2 < len) {
                num = num * 10 + (digitChars[offset2] - 48);
                if (++offset2 < len) {
                    num = num * 10 + (digitChars[offset2] - 48);
                    if (++offset2 < len) {
                        num = num * 10 + (digitChars[offset2] - 48);
                        if (++offset2 < len) {
                            num = num * 10 + (digitChars[offset2] - 48);
                            if (++offset2 < len) {
                                num = num * 10 + (digitChars[offset2] - 48);
                                if (++offset2 < len) {
                                    num = num * 10 + (digitChars[offset2] - 48);
                                    if (++offset2 < len) {
                                        num = num * 10 + (digitChars[offset2] - 48);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return num;
    }

    public static int parseInt(String str) {
        char c = str.charAt(0);
        int length2 = str.length();
        boolean negative = c == '-';
        int offset2 = 1;
        if (negative) {
            if (length2 == 1 || length2 > 10) {
                return Integer.parseInt(str);
            }
            c = str.charAt(offset2++);
        } else if (length2 > 9) {
            return Integer.parseInt(str);
        }
        if (c > '9' || c < '0') {
            return Integer.parseInt(str);
        }
        int num = c - 48;
        if (offset2 < length2) {
            if ((c = str.charAt(offset2++)) > '9' || c < '0') {
                return Integer.parseInt(str);
            }
            num = num * 10 + (c - 48);
            if (offset2 < length2) {
                if ((c = str.charAt(offset2++)) > '9' || c < '0') {
                    return Integer.parseInt(str);
                }
                num = num * 10 + (c - 48);
                if (offset2 < length2) {
                    do {
                        if ((c = str.charAt(offset2++)) > '9' || c < '0') {
                            return Integer.parseInt(str);
                        }
                        num = num * 10 + (c - 48);
                    } while (offset2 < length2);
                }
            }
        }
        return negative ? -num : num;
    }

    public static long parseLong(char[] digitChars, int offset2, int len) {
        int len1 = len - 9;
        long val = (long)NumberInput.parseInt(digitChars, offset2, len1) * 1000000000L;
        return val + (long)NumberInput.parseInt(digitChars, offset2 + len1, 9);
    }

    public static long parseLong(String str) {
        int length2 = str.length();
        if (length2 <= 9) {
            return NumberInput.parseInt(str);
        }
        return Long.parseLong(str);
    }

    public static boolean inLongRange(char[] digitChars, int offset2, int len, boolean negative) {
        String cmpStr = negative ? MIN_LONG_STR_NO_SIGN : MAX_LONG_STR;
        int cmpLen = cmpStr.length();
        if (len < cmpLen) {
            return true;
        }
        if (len > cmpLen) {
            return false;
        }
        for (int i2 = 0; i2 < cmpLen; ++i2) {
            int diff = digitChars[offset2 + i2] - cmpStr.charAt(i2);
            if (diff == 0) continue;
            return diff < 0;
        }
        return true;
    }

    public static boolean inLongRange(String numberStr, boolean negative) {
        String cmpStr = negative ? MIN_LONG_STR_NO_SIGN : MAX_LONG_STR;
        int cmpLen = cmpStr.length();
        int actualLen = numberStr.length();
        if (actualLen < cmpLen) {
            return true;
        }
        if (actualLen > cmpLen) {
            return false;
        }
        for (int i2 = 0; i2 < cmpLen; ++i2) {
            int diff = numberStr.charAt(i2) - cmpStr.charAt(i2);
            if (diff == 0) continue;
            return diff < 0;
        }
        return true;
    }

    public static int parseAsInt(String input, int defaultValue) {
        char c;
        if (input == null) {
            return defaultValue;
        }
        int len = (input = input.trim()).length();
        if (len == 0) {
            return defaultValue;
        }
        int i2 = 0;
        if (i2 < len) {
            c = input.charAt(0);
            if (c == '+') {
                input = input.substring(1);
                len = input.length();
            } else if (c == '-') {
                ++i2;
            }
        }
        while (i2 < len) {
            c = input.charAt(i2);
            if (c > '9' || c < '0') {
                try {
                    return (int)NumberInput.parseDouble(input);
                }
                catch (NumberFormatException e) {
                    return defaultValue;
                }
            }
            ++i2;
        }
        try {
            return Integer.parseInt(input);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long parseAsLong(String input, long defaultValue) {
        char c;
        if (input == null) {
            return defaultValue;
        }
        int len = (input = input.trim()).length();
        if (len == 0) {
            return defaultValue;
        }
        int i2 = 0;
        if (i2 < len) {
            c = input.charAt(0);
            if (c == '+') {
                input = input.substring(1);
                len = input.length();
            } else if (c == '-') {
                ++i2;
            }
        }
        while (i2 < len) {
            c = input.charAt(i2);
            if (c > '9' || c < '0') {
                try {
                    return (long)NumberInput.parseDouble(input);
                }
                catch (NumberFormatException e) {
                    return defaultValue;
                }
            }
            ++i2;
        }
        try {
            return Long.parseLong(input);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static double parseAsDouble(String input, double defaultValue) {
        if (input == null) {
            return defaultValue;
        }
        int len = (input = input.trim()).length();
        if (len == 0) {
            return defaultValue;
        }
        try {
            return NumberInput.parseDouble(input);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static double parseDouble(String numStr) throws NumberFormatException {
        if (NASTY_SMALL_DOUBLE.equals(numStr)) {
            return Double.MIN_VALUE;
        }
        return Double.parseDouble(numStr);
    }
}

